/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.DataAccountType;
import com.azure.resourcemanager.databox.models.ShareCredentialDetails;
import java.io.IOException;
import java.util.List;

public final class AccountCredentialDetails
implements JsonSerializable<AccountCredentialDetails> {
    private String accountName;
    private DataAccountType dataAccountType;
    private String accountConnectionString;
    private List<ShareCredentialDetails> shareCredentialDetails;

    public String accountName() {
        return this.accountName;
    }

    public DataAccountType dataAccountType() {
        return this.dataAccountType;
    }

    public String accountConnectionString() {
        return this.accountConnectionString;
    }

    public List<ShareCredentialDetails> shareCredentialDetails() {
        return this.shareCredentialDetails;
    }

    public void validate() {
        if (this.shareCredentialDetails() != null) {
            this.shareCredentialDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static AccountCredentialDetails fromJson(JsonReader jsonReader) throws IOException {
        return (AccountCredentialDetails)jsonReader.readObject(reader -> {
            AccountCredentialDetails deserializedAccountCredentialDetails = new AccountCredentialDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountName".equals(fieldName)) {
                    deserializedAccountCredentialDetails.accountName = reader.getString();
                    continue;
                }
                if ("dataAccountType".equals(fieldName)) {
                    deserializedAccountCredentialDetails.dataAccountType = DataAccountType.fromString(reader.getString());
                    continue;
                }
                if ("accountConnectionString".equals(fieldName)) {
                    deserializedAccountCredentialDetails.accountConnectionString = reader.getString();
                    continue;
                }
                if ("shareCredentialDetails".equals(fieldName)) {
                    List shareCredentialDetails;
                    deserializedAccountCredentialDetails.shareCredentialDetails = shareCredentialDetails = reader.readArray(reader1 -> ShareCredentialDetails.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccountCredentialDetails;
        });
    }
}

