/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.databox.DataBoxManager;
import com.azure.resourcemanager.databox.fluent.ServicesClient;
import com.azure.resourcemanager.databox.fluent.models.AddressValidationOutputInner;
import com.azure.resourcemanager.databox.fluent.models.RegionConfigurationResponseInner;
import com.azure.resourcemanager.databox.fluent.models.SkuInformationInner;
import com.azure.resourcemanager.databox.fluent.models.ValidationResponseInner;
import com.azure.resourcemanager.databox.implementation.AddressValidationOutputImpl;
import com.azure.resourcemanager.databox.implementation.RegionConfigurationResponseImpl;
import com.azure.resourcemanager.databox.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.databox.implementation.SkuInformationImpl;
import com.azure.resourcemanager.databox.implementation.ValidationResponseImpl;
import com.azure.resourcemanager.databox.models.AddressValidationOutput;
import com.azure.resourcemanager.databox.models.AvailableSkuRequest;
import com.azure.resourcemanager.databox.models.RegionConfigurationRequest;
import com.azure.resourcemanager.databox.models.RegionConfigurationResponse;
import com.azure.resourcemanager.databox.models.Services;
import com.azure.resourcemanager.databox.models.SkuInformation;
import com.azure.resourcemanager.databox.models.ValidateAddress;
import com.azure.resourcemanager.databox.models.ValidationRequest;
import com.azure.resourcemanager.databox.models.ValidationResponse;

public final class ServicesImpl
implements Services {
    private static final ClientLogger LOGGER = new ClientLogger(ServicesImpl.class);
    private final ServicesClient innerClient;
    private final DataBoxManager serviceManager;

    public ServicesImpl(ServicesClient innerClient, DataBoxManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SkuInformation> listAvailableSkusByResourceGroup(String resourceGroupName, String location, AvailableSkuRequest availableSkuRequest) {
        PagedIterable<SkuInformationInner> inner = this.serviceClient().listAvailableSkusByResourceGroup(resourceGroupName, location, availableSkuRequest);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SkuInformationImpl((SkuInformationInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<SkuInformation> listAvailableSkusByResourceGroup(String resourceGroupName, String location, AvailableSkuRequest availableSkuRequest, Context context) {
        PagedIterable<SkuInformationInner> inner = this.serviceClient().listAvailableSkusByResourceGroup(resourceGroupName, location, availableSkuRequest, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SkuInformationImpl((SkuInformationInner)inner1, this.manager()));
    }

    @Override
    public Response<AddressValidationOutput> validateAddressWithResponse(String location, ValidateAddress validateAddress, Context context) {
        Response<AddressValidationOutputInner> inner = this.serviceClient().validateAddressWithResponse(location, validateAddress, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AddressValidationOutputImpl((AddressValidationOutputInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AddressValidationOutput validateAddress(String location, ValidateAddress validateAddress) {
        AddressValidationOutputInner inner = this.serviceClient().validateAddress(location, validateAddress);
        if (inner != null) {
            return new AddressValidationOutputImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ValidationResponse> validateInputsByResourceGroupWithResponse(String resourceGroupName, String location, ValidationRequest validationRequest, Context context) {
        Response<ValidationResponseInner> inner = this.serviceClient().validateInputsByResourceGroupWithResponse(resourceGroupName, location, validationRequest, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ValidationResponseImpl((ValidationResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ValidationResponse validateInputsByResourceGroup(String resourceGroupName, String location, ValidationRequest validationRequest) {
        ValidationResponseInner inner = this.serviceClient().validateInputsByResourceGroup(resourceGroupName, location, validationRequest);
        if (inner != null) {
            return new ValidationResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ValidationResponse> validateInputsWithResponse(String location, ValidationRequest validationRequest, Context context) {
        Response<ValidationResponseInner> inner = this.serviceClient().validateInputsWithResponse(location, validationRequest, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ValidationResponseImpl((ValidationResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ValidationResponse validateInputs(String location, ValidationRequest validationRequest) {
        ValidationResponseInner inner = this.serviceClient().validateInputs(location, validationRequest);
        if (inner != null) {
            return new ValidationResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<RegionConfigurationResponse> regionConfigurationWithResponse(String location, RegionConfigurationRequest regionConfigurationRequest, Context context) {
        Response<RegionConfigurationResponseInner> inner = this.serviceClient().regionConfigurationWithResponse(location, regionConfigurationRequest, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RegionConfigurationResponseImpl((RegionConfigurationResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public RegionConfigurationResponse regionConfiguration(String location, RegionConfigurationRequest regionConfigurationRequest) {
        RegionConfigurationResponseInner inner = this.serviceClient().regionConfiguration(location, regionConfigurationRequest);
        if (inner != null) {
            return new RegionConfigurationResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<RegionConfigurationResponse> regionConfigurationByResourceGroupWithResponse(String resourceGroupName, String location, RegionConfigurationRequest regionConfigurationRequest, Context context) {
        Response<RegionConfigurationResponseInner> inner = this.serviceClient().regionConfigurationByResourceGroupWithResponse(resourceGroupName, location, regionConfigurationRequest, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RegionConfigurationResponseImpl((RegionConfigurationResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public RegionConfigurationResponse regionConfigurationByResourceGroup(String resourceGroupName, String location, RegionConfigurationRequest regionConfigurationRequest) {
        RegionConfigurationResponseInner inner = this.serviceClient().regionConfigurationByResourceGroup(resourceGroupName, location, regionConfigurationRequest);
        if (inner != null) {
            return new RegionConfigurationResponseImpl(inner, this.manager());
        }
        return null;
    }

    private ServicesClient serviceClient() {
        return this.innerClient;
    }

    private DataBoxManager manager() {
        return this.serviceManager;
    }
}

