/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.databox.fluent.ServicesClient;
import com.azure.resourcemanager.databox.fluent.models.AddressValidationOutputInner;
import com.azure.resourcemanager.databox.fluent.models.RegionConfigurationResponseInner;
import com.azure.resourcemanager.databox.fluent.models.SkuInformationInner;
import com.azure.resourcemanager.databox.fluent.models.ValidationResponseInner;
import com.azure.resourcemanager.databox.implementation.DataBoxManagementClientImpl;
import com.azure.resourcemanager.databox.models.AvailableSkuRequest;
import com.azure.resourcemanager.databox.models.AvailableSkusResult;
import com.azure.resourcemanager.databox.models.RegionConfigurationRequest;
import com.azure.resourcemanager.databox.models.ValidateAddress;
import com.azure.resourcemanager.databox.models.ValidationRequest;
import reactor.core.publisher.Mono;

public final class ServicesClientImpl
implements ServicesClient {
    private final ServicesService service;
    private final DataBoxManagementClientImpl client;

    ServicesClientImpl(DataBoxManagementClientImpl client) {
        this.service = (ServicesService)RestProxy.create(ServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SkuInformationInner>> listAvailableSkusByResourceGroupSinglePageAsync(String resourceGroupName, String location, AvailableSkuRequest availableSkuRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (availableSkuRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availableSkuRequest is required and cannot be null."));
        }
        availableSkuRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAvailableSkusByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, location, this.client.getApiVersion(), availableSkuRequest, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvailableSkusResult)res.getValue()).value(), ((AvailableSkusResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SkuInformationInner>> listAvailableSkusByResourceGroupSinglePageAsync(String resourceGroupName, String location, AvailableSkuRequest availableSkuRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (availableSkuRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availableSkuRequest is required and cannot be null."));
        }
        availableSkuRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAvailableSkusByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, location, this.client.getApiVersion(), availableSkuRequest, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvailableSkusResult)res.getValue()).value(), ((AvailableSkusResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SkuInformationInner> listAvailableSkusByResourceGroupAsync(String resourceGroupName, String location, AvailableSkuRequest availableSkuRequest) {
        return new PagedFlux(() -> this.listAvailableSkusByResourceGroupSinglePageAsync(resourceGroupName, location, availableSkuRequest), nextLink -> this.listAvailableSkusByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SkuInformationInner> listAvailableSkusByResourceGroupAsync(String resourceGroupName, String location, AvailableSkuRequest availableSkuRequest, Context context) {
        return new PagedFlux(() -> this.listAvailableSkusByResourceGroupSinglePageAsync(resourceGroupName, location, availableSkuRequest, context), nextLink -> this.listAvailableSkusByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SkuInformationInner> listAvailableSkusByResourceGroup(String resourceGroupName, String location, AvailableSkuRequest availableSkuRequest) {
        return new PagedIterable(this.listAvailableSkusByResourceGroupAsync(resourceGroupName, location, availableSkuRequest));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SkuInformationInner> listAvailableSkusByResourceGroup(String resourceGroupName, String location, AvailableSkuRequest availableSkuRequest, Context context) {
        return new PagedIterable(this.listAvailableSkusByResourceGroupAsync(resourceGroupName, location, availableSkuRequest, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AddressValidationOutputInner>> validateAddressWithResponseAsync(String location, ValidateAddress validateAddress) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (validateAddress == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter validateAddress is required and cannot be null."));
        }
        validateAddress.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateAddress(this.client.getEndpoint(), this.client.getSubscriptionId(), location, this.client.getApiVersion(), validateAddress, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AddressValidationOutputInner>> validateAddressWithResponseAsync(String location, ValidateAddress validateAddress, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (validateAddress == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter validateAddress is required and cannot be null."));
        }
        validateAddress.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateAddress(this.client.getEndpoint(), this.client.getSubscriptionId(), location, this.client.getApiVersion(), validateAddress, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AddressValidationOutputInner> validateAddressAsync(String location, ValidateAddress validateAddress) {
        return this.validateAddressWithResponseAsync(location, validateAddress).flatMap(res -> Mono.justOrEmpty((Object)((AddressValidationOutputInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AddressValidationOutputInner> validateAddressWithResponse(String location, ValidateAddress validateAddress, Context context) {
        return (Response)this.validateAddressWithResponseAsync(location, validateAddress, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AddressValidationOutputInner validateAddress(String location, ValidateAddress validateAddress) {
        return (AddressValidationOutputInner)this.validateAddressWithResponse(location, validateAddress, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ValidationResponseInner>> validateInputsByResourceGroupWithResponseAsync(String resourceGroupName, String location, ValidationRequest validationRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (validationRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter validationRequest is required and cannot be null."));
        }
        validationRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateInputsByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, location, this.client.getApiVersion(), validationRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ValidationResponseInner>> validateInputsByResourceGroupWithResponseAsync(String resourceGroupName, String location, ValidationRequest validationRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (validationRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter validationRequest is required and cannot be null."));
        }
        validationRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateInputsByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, location, this.client.getApiVersion(), validationRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ValidationResponseInner> validateInputsByResourceGroupAsync(String resourceGroupName, String location, ValidationRequest validationRequest) {
        return this.validateInputsByResourceGroupWithResponseAsync(resourceGroupName, location, validationRequest).flatMap(res -> Mono.justOrEmpty((Object)((ValidationResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ValidationResponseInner> validateInputsByResourceGroupWithResponse(String resourceGroupName, String location, ValidationRequest validationRequest, Context context) {
        return (Response)this.validateInputsByResourceGroupWithResponseAsync(resourceGroupName, location, validationRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ValidationResponseInner validateInputsByResourceGroup(String resourceGroupName, String location, ValidationRequest validationRequest) {
        return (ValidationResponseInner)this.validateInputsByResourceGroupWithResponse(resourceGroupName, location, validationRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ValidationResponseInner>> validateInputsWithResponseAsync(String location, ValidationRequest validationRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (validationRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter validationRequest is required and cannot be null."));
        }
        validationRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateInputs(this.client.getEndpoint(), this.client.getSubscriptionId(), location, this.client.getApiVersion(), validationRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ValidationResponseInner>> validateInputsWithResponseAsync(String location, ValidationRequest validationRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (validationRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter validationRequest is required and cannot be null."));
        }
        validationRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateInputs(this.client.getEndpoint(), this.client.getSubscriptionId(), location, this.client.getApiVersion(), validationRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ValidationResponseInner> validateInputsAsync(String location, ValidationRequest validationRequest) {
        return this.validateInputsWithResponseAsync(location, validationRequest).flatMap(res -> Mono.justOrEmpty((Object)((ValidationResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ValidationResponseInner> validateInputsWithResponse(String location, ValidationRequest validationRequest, Context context) {
        return (Response)this.validateInputsWithResponseAsync(location, validationRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ValidationResponseInner validateInputs(String location, ValidationRequest validationRequest) {
        return (ValidationResponseInner)this.validateInputsWithResponse(location, validationRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RegionConfigurationResponseInner>> regionConfigurationWithResponseAsync(String location, RegionConfigurationRequest regionConfigurationRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (regionConfigurationRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regionConfigurationRequest is required and cannot be null."));
        }
        regionConfigurationRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.regionConfiguration(this.client.getEndpoint(), this.client.getSubscriptionId(), location, this.client.getApiVersion(), regionConfigurationRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RegionConfigurationResponseInner>> regionConfigurationWithResponseAsync(String location, RegionConfigurationRequest regionConfigurationRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (regionConfigurationRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regionConfigurationRequest is required and cannot be null."));
        }
        regionConfigurationRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.regionConfiguration(this.client.getEndpoint(), this.client.getSubscriptionId(), location, this.client.getApiVersion(), regionConfigurationRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RegionConfigurationResponseInner> regionConfigurationAsync(String location, RegionConfigurationRequest regionConfigurationRequest) {
        return this.regionConfigurationWithResponseAsync(location, regionConfigurationRequest).flatMap(res -> Mono.justOrEmpty((Object)((RegionConfigurationResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RegionConfigurationResponseInner> regionConfigurationWithResponse(String location, RegionConfigurationRequest regionConfigurationRequest, Context context) {
        return (Response)this.regionConfigurationWithResponseAsync(location, regionConfigurationRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RegionConfigurationResponseInner regionConfiguration(String location, RegionConfigurationRequest regionConfigurationRequest) {
        return (RegionConfigurationResponseInner)this.regionConfigurationWithResponse(location, regionConfigurationRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RegionConfigurationResponseInner>> regionConfigurationByResourceGroupWithResponseAsync(String resourceGroupName, String location, RegionConfigurationRequest regionConfigurationRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (regionConfigurationRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regionConfigurationRequest is required and cannot be null."));
        }
        regionConfigurationRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.regionConfigurationByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, location, this.client.getApiVersion(), regionConfigurationRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RegionConfigurationResponseInner>> regionConfigurationByResourceGroupWithResponseAsync(String resourceGroupName, String location, RegionConfigurationRequest regionConfigurationRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (regionConfigurationRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regionConfigurationRequest is required and cannot be null."));
        }
        regionConfigurationRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.regionConfigurationByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, location, this.client.getApiVersion(), regionConfigurationRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RegionConfigurationResponseInner> regionConfigurationByResourceGroupAsync(String resourceGroupName, String location, RegionConfigurationRequest regionConfigurationRequest) {
        return this.regionConfigurationByResourceGroupWithResponseAsync(resourceGroupName, location, regionConfigurationRequest).flatMap(res -> Mono.justOrEmpty((Object)((RegionConfigurationResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RegionConfigurationResponseInner> regionConfigurationByResourceGroupWithResponse(String resourceGroupName, String location, RegionConfigurationRequest regionConfigurationRequest, Context context) {
        return (Response)this.regionConfigurationByResourceGroupWithResponseAsync(resourceGroupName, location, regionConfigurationRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RegionConfigurationResponseInner regionConfigurationByResourceGroup(String resourceGroupName, String location, RegionConfigurationRequest regionConfigurationRequest) {
        return (RegionConfigurationResponseInner)this.regionConfigurationByResourceGroupWithResponse(resourceGroupName, location, regionConfigurationRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SkuInformationInner>> listAvailableSkusByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAvailableSkusByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvailableSkusResult)res.getValue()).value(), ((AvailableSkusResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SkuInformationInner>> listAvailableSkusByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAvailableSkusByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvailableSkusResult)res.getValue()).value(), ((AvailableSkusResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataBoxManagementCli")
    public static interface ServicesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/locations/{location}/availableSkus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AvailableSkusResult>> listAvailableSkusByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="location") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") AvailableSkuRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/locations/{location}/validateAddress")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AddressValidationOutputInner>> validateAddress(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="location") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") ValidateAddress var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/locations/{location}/validateInputs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ValidationResponseInner>> validateInputsByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="location") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") ValidationRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/locations/{location}/validateInputs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ValidationResponseInner>> validateInputs(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="location") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") ValidationRequest var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/locations/{location}/regionConfiguration")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RegionConfigurationResponseInner>> regionConfiguration(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="location") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") RegionConfigurationRequest var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/locations/{location}/regionConfiguration")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RegionConfigurationResponseInner>> regionConfigurationByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="location") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") RegionConfigurationRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AvailableSkusResult>> listAvailableSkusByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

