/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.databox.DataBoxManager;
import com.azure.resourcemanager.databox.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.databox.models.MitigateJobRequest;
import com.azure.resourcemanager.databox.models.ResourceProviders;

public final class ResourceProvidersImpl
implements ResourceProviders {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProvidersImpl.class);
    private final ResourceProvidersClient innerClient;
    private final DataBoxManager serviceManager;

    public ResourceProvidersImpl(ResourceProvidersClient innerClient, DataBoxManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> mitigateWithResponse(String jobName, String resourceGroupName, MitigateJobRequest mitigateJobRequest, Context context) {
        return this.serviceClient().mitigateWithResponse(jobName, resourceGroupName, mitigateJobRequest, context);
    }

    @Override
    public void mitigate(String jobName, String resourceGroupName, MitigateJobRequest mitigateJobRequest) {
        this.serviceClient().mitigate(jobName, resourceGroupName, mitigateJobRequest);
    }

    private ResourceProvidersClient serviceClient() {
        return this.innerClient;
    }

    private DataBoxManager manager() {
        return this.serviceManager;
    }
}

