/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.databox.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.databox.implementation.DataBoxManagementClientImpl;
import com.azure.resourcemanager.databox.models.MitigateJobRequest;
import reactor.core.publisher.Mono;

public final class ResourceProvidersClientImpl
implements ResourceProvidersClient {
    private final ResourceProvidersService service;
    private final DataBoxManagementClientImpl client;

    ResourceProvidersClientImpl(DataBoxManagementClientImpl client) {
        this.service = (ResourceProvidersService)RestProxy.create(ResourceProvidersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> mitigateWithResponseAsync(String jobName, String resourceGroupName, MitigateJobRequest mitigateJobRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mitigateJobRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mitigateJobRequest is required and cannot be null."));
        }
        mitigateJobRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.mitigate(this.client.getEndpoint(), jobName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), mitigateJobRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> mitigateWithResponseAsync(String jobName, String resourceGroupName, MitigateJobRequest mitigateJobRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mitigateJobRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mitigateJobRequest is required and cannot be null."));
        }
        mitigateJobRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.mitigate(this.client.getEndpoint(), jobName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), mitigateJobRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> mitigateAsync(String jobName, String resourceGroupName, MitigateJobRequest mitigateJobRequest) {
        return this.mitigateWithResponseAsync(jobName, resourceGroupName, mitigateJobRequest).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> mitigateWithResponse(String jobName, String resourceGroupName, MitigateJobRequest mitigateJobRequest, Context context) {
        return (Response)this.mitigateWithResponseAsync(jobName, resourceGroupName, mitigateJobRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void mitigate(String jobName, String resourceGroupName, MitigateJobRequest mitigateJobRequest) {
        this.mitigateWithResponse(jobName, resourceGroupName, mitigateJobRequest, Context.NONE);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataBoxManagementCli")
    public static interface ResourceProvidersService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}/mitigate")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> mitigate(@HostParam(value="$host") String var1, @PathParam(value="jobName") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") MitigateJobRequest var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

