/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.databox.DataBoxManager;
import com.azure.resourcemanager.databox.fluent.JobsClient;
import com.azure.resourcemanager.databox.fluent.models.JobResourceInner;
import com.azure.resourcemanager.databox.fluent.models.ShipmentPickUpResponseInner;
import com.azure.resourcemanager.databox.fluent.models.UnencryptedCredentialsInner;
import com.azure.resourcemanager.databox.implementation.JobResourceImpl;
import com.azure.resourcemanager.databox.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.databox.implementation.ShipmentPickUpResponseImpl;
import com.azure.resourcemanager.databox.implementation.UnencryptedCredentialsImpl;
import com.azure.resourcemanager.databox.models.CancellationReason;
import com.azure.resourcemanager.databox.models.JobResource;
import com.azure.resourcemanager.databox.models.Jobs;
import com.azure.resourcemanager.databox.models.MarkDevicesShippedRequest;
import com.azure.resourcemanager.databox.models.ShipmentPickUpRequest;
import com.azure.resourcemanager.databox.models.ShipmentPickUpResponse;
import com.azure.resourcemanager.databox.models.UnencryptedCredentials;

public final class JobsImpl
implements Jobs {
    private static final ClientLogger LOGGER = new ClientLogger(JobsImpl.class);
    private final JobsClient innerClient;
    private final DataBoxManager serviceManager;

    public JobsImpl(JobsClient innerClient, DataBoxManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<JobResource> list() {
        PagedIterable<JobResourceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobResourceImpl((JobResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<JobResource> list(String skipToken, Context context) {
        PagedIterable<JobResourceInner> inner = this.serviceClient().list(skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobResourceImpl((JobResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Void> markDevicesShippedWithResponse(String jobName, String resourceGroupName, MarkDevicesShippedRequest markDevicesShippedRequest, Context context) {
        return this.serviceClient().markDevicesShippedWithResponse(jobName, resourceGroupName, markDevicesShippedRequest, context);
    }

    @Override
    public void markDevicesShipped(String jobName, String resourceGroupName, MarkDevicesShippedRequest markDevicesShippedRequest) {
        this.serviceClient().markDevicesShipped(jobName, resourceGroupName, markDevicesShippedRequest);
    }

    @Override
    public PagedIterable<JobResource> listByResourceGroup(String resourceGroupName) {
        PagedIterable<JobResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobResourceImpl((JobResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<JobResource> listByResourceGroup(String resourceGroupName, String skipToken, Context context) {
        PagedIterable<JobResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobResourceImpl((JobResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<JobResource> getByResourceGroupWithResponse(String resourceGroupName, String jobName, String expand, Context context) {
        Response<JobResourceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, jobName, expand, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JobResourceImpl((JobResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public JobResource getByResourceGroup(String resourceGroupName, String jobName) {
        JobResourceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, jobName);
        if (inner != null) {
            return new JobResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String jobName) {
        this.serviceClient().delete(resourceGroupName, jobName);
    }

    @Override
    public void delete(String resourceGroupName, String jobName, Context context) {
        this.serviceClient().delete(resourceGroupName, jobName, context);
    }

    @Override
    public Response<ShipmentPickUpResponse> bookShipmentPickUpWithResponse(String resourceGroupName, String jobName, ShipmentPickUpRequest shipmentPickUpRequest, Context context) {
        Response<ShipmentPickUpResponseInner> inner = this.serviceClient().bookShipmentPickUpWithResponse(resourceGroupName, jobName, shipmentPickUpRequest, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ShipmentPickUpResponseImpl((ShipmentPickUpResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ShipmentPickUpResponse bookShipmentPickUp(String resourceGroupName, String jobName, ShipmentPickUpRequest shipmentPickUpRequest) {
        ShipmentPickUpResponseInner inner = this.serviceClient().bookShipmentPickUp(resourceGroupName, jobName, shipmentPickUpRequest);
        if (inner != null) {
            return new ShipmentPickUpResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> cancelWithResponse(String resourceGroupName, String jobName, CancellationReason cancellationReason, Context context) {
        return this.serviceClient().cancelWithResponse(resourceGroupName, jobName, cancellationReason, context);
    }

    @Override
    public void cancel(String resourceGroupName, String jobName, CancellationReason cancellationReason) {
        this.serviceClient().cancel(resourceGroupName, jobName, cancellationReason);
    }

    @Override
    public PagedIterable<UnencryptedCredentials> listCredentials(String resourceGroupName, String jobName) {
        PagedIterable<UnencryptedCredentialsInner> inner = this.serviceClient().listCredentials(resourceGroupName, jobName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UnencryptedCredentialsImpl((UnencryptedCredentialsInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<UnencryptedCredentials> listCredentials(String resourceGroupName, String jobName, Context context) {
        PagedIterable<UnencryptedCredentialsInner> inner = this.serviceClient().listCredentials(resourceGroupName, jobName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UnencryptedCredentialsImpl((UnencryptedCredentialsInner)inner1, this.manager()));
    }

    @Override
    public JobResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String jobName = ResourceManagerUtils.getValueFromIdByName(id, "jobs");
        if (jobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jobs'.", id)));
        }
        String localExpand = null;
        return (JobResource)this.getByResourceGroupWithResponse(resourceGroupName, jobName, localExpand, Context.NONE).getValue();
    }

    @Override
    public Response<JobResource> getByIdWithResponse(String id, String expand, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String jobName = ResourceManagerUtils.getValueFromIdByName(id, "jobs");
        if (jobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jobs'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, jobName, expand, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String jobName = ResourceManagerUtils.getValueFromIdByName(id, "jobs");
        if (jobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jobs'.", id)));
        }
        this.delete(resourceGroupName, jobName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String jobName = ResourceManagerUtils.getValueFromIdByName(id, "jobs");
        if (jobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jobs'.", id)));
        }
        this.delete(resourceGroupName, jobName, context);
    }

    private JobsClient serviceClient() {
        return this.innerClient;
    }

    private DataBoxManager manager() {
        return this.serviceManager;
    }

    @Override
    public JobResourceImpl define(String name) {
        return new JobResourceImpl(name, this.manager());
    }
}

