/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.databox.fluent.JobsClient;
import com.azure.resourcemanager.databox.fluent.models.JobResourceInner;
import com.azure.resourcemanager.databox.fluent.models.ShipmentPickUpResponseInner;
import com.azure.resourcemanager.databox.fluent.models.UnencryptedCredentialsInner;
import com.azure.resourcemanager.databox.implementation.DataBoxManagementClientImpl;
import com.azure.resourcemanager.databox.models.CancellationReason;
import com.azure.resourcemanager.databox.models.JobResourceList;
import com.azure.resourcemanager.databox.models.JobResourceUpdateParameter;
import com.azure.resourcemanager.databox.models.MarkDevicesShippedRequest;
import com.azure.resourcemanager.databox.models.ShipmentPickUpRequest;
import com.azure.resourcemanager.databox.models.UnencryptedCredentialsList;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class JobsClientImpl
implements JobsClient {
    private final JobsService service;
    private final DataBoxManagementClientImpl client;

    JobsClientImpl(DataBoxManagementClientImpl client) {
        this.service = (JobsService)RestProxy.create(JobsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobResourceInner>> listSinglePageAsync(String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobResourceList)res.getValue()).value(), ((JobResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobResourceInner>> listSinglePageAsync(String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobResourceList)res.getValue()).value(), ((JobResourceList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobResourceInner> listAsync(String skipToken) {
        return new PagedFlux(() -> this.listSinglePageAsync(skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobResourceInner> listAsync() {
        String skipToken = null;
        return new PagedFlux(() -> this.listSinglePageAsync(skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobResourceInner> listAsync(String skipToken, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(skipToken, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JobResourceInner> list() {
        String skipToken = null;
        return new PagedIterable(this.listAsync(skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JobResourceInner> list(String skipToken, Context context) {
        return new PagedIterable(this.listAsync(skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> markDevicesShippedWithResponseAsync(String jobName, String resourceGroupName, MarkDevicesShippedRequest markDevicesShippedRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (markDevicesShippedRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter markDevicesShippedRequest is required and cannot be null."));
        }
        markDevicesShippedRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.markDevicesShipped(this.client.getEndpoint(), jobName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), markDevicesShippedRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> markDevicesShippedWithResponseAsync(String jobName, String resourceGroupName, MarkDevicesShippedRequest markDevicesShippedRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (markDevicesShippedRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter markDevicesShippedRequest is required and cannot be null."));
        }
        markDevicesShippedRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.markDevicesShipped(this.client.getEndpoint(), jobName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), markDevicesShippedRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> markDevicesShippedAsync(String jobName, String resourceGroupName, MarkDevicesShippedRequest markDevicesShippedRequest) {
        return this.markDevicesShippedWithResponseAsync(jobName, resourceGroupName, markDevicesShippedRequest).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> markDevicesShippedWithResponse(String jobName, String resourceGroupName, MarkDevicesShippedRequest markDevicesShippedRequest, Context context) {
        return (Response)this.markDevicesShippedWithResponseAsync(jobName, resourceGroupName, markDevicesShippedRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void markDevicesShipped(String jobName, String resourceGroupName, MarkDevicesShippedRequest markDevicesShippedRequest) {
        this.markDevicesShippedWithResponse(jobName, resourceGroupName, markDevicesShippedRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobResourceList)res.getValue()).value(), ((JobResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobResourceList)res.getValue()).value(), ((JobResourceList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobResourceInner> listByResourceGroupAsync(String resourceGroupName, String skipToken) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, skipToken), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobResourceInner> listByResourceGroupAsync(String resourceGroupName) {
        String skipToken = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, skipToken), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobResourceInner> listByResourceGroupAsync(String resourceGroupName, String skipToken, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, skipToken, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JobResourceInner> listByResourceGroup(String resourceGroupName) {
        String skipToken = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JobResourceInner> listByResourceGroup(String resourceGroupName, String skipToken, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String jobName, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, this.client.getApiVersion(), expand, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String jobName, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, this.client.getApiVersion(), expand, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JobResourceInner> getByResourceGroupAsync(String resourceGroupName, String jobName) {
        String expand = null;
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, jobName, expand).flatMap(res -> Mono.justOrEmpty((Object)((Object)((JobResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<JobResourceInner> getByResourceGroupWithResponse(String resourceGroupName, String jobName, String expand, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, jobName, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobResourceInner getByResourceGroup(String resourceGroupName, String jobName) {
        String expand = null;
        return (JobResourceInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, jobName, expand, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String jobName, JobResourceInner jobResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobResource is required and cannot be null."));
        }
        jobResource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, this.client.getApiVersion(), jobResource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String jobName, JobResourceInner jobResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobResource is required and cannot be null."));
        }
        jobResource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, this.client.getApiVersion(), jobResource, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<JobResourceInner>, JobResourceInner> beginCreateAsync(String resourceGroupName, String jobName, JobResourceInner jobResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, jobName, jobResource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)JobResourceInner.class), (Type)((Object)JobResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<JobResourceInner>, JobResourceInner> beginCreateAsync(String resourceGroupName, String jobName, JobResourceInner jobResource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, jobName, jobResource, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)JobResourceInner.class), (Type)((Object)JobResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<JobResourceInner>, JobResourceInner> beginCreate(String resourceGroupName, String jobName, JobResourceInner jobResource) {
        return this.beginCreateAsync(resourceGroupName, jobName, jobResource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<JobResourceInner>, JobResourceInner> beginCreate(String resourceGroupName, String jobName, JobResourceInner jobResource, Context context) {
        return this.beginCreateAsync(resourceGroupName, jobName, jobResource, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JobResourceInner> createAsync(String resourceGroupName, String jobName, JobResourceInner jobResource) {
        return this.beginCreateAsync(resourceGroupName, jobName, jobResource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JobResourceInner> createAsync(String resourceGroupName, String jobName, JobResourceInner jobResource, Context context) {
        return this.beginCreateAsync(resourceGroupName, jobName, jobResource, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobResourceInner create(String resourceGroupName, String jobName, JobResourceInner jobResource) {
        return (JobResourceInner)((Object)this.createAsync(resourceGroupName, jobName, jobResource).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobResourceInner create(String resourceGroupName, String jobName, JobResourceInner jobResource, Context context) {
        return (JobResourceInner)((Object)this.createAsync(resourceGroupName, jobName, jobResource, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String jobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String jobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String jobName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, jobName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String jobName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, jobName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String jobName) {
        return this.beginDeleteAsync(resourceGroupName, jobName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String jobName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, jobName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String jobName) {
        return this.beginDeleteAsync(resourceGroupName, jobName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String jobName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, jobName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String jobName) {
        this.deleteAsync(resourceGroupName, jobName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String jobName, Context context) {
        this.deleteAsync(resourceGroupName, jobName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String jobName, JobResourceUpdateParameter jobResourceUpdateParameter, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobResourceUpdateParameter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobResourceUpdateParameter is required and cannot be null."));
        }
        jobResourceUpdateParameter.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, this.client.getApiVersion(), ifMatch, jobResourceUpdateParameter, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String jobName, JobResourceUpdateParameter jobResourceUpdateParameter, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobResourceUpdateParameter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobResourceUpdateParameter is required and cannot be null."));
        }
        jobResourceUpdateParameter.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, this.client.getApiVersion(), ifMatch, jobResourceUpdateParameter, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<JobResourceInner>, JobResourceInner> beginUpdateAsync(String resourceGroupName, String jobName, JobResourceUpdateParameter jobResourceUpdateParameter, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, jobName, jobResourceUpdateParameter, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)JobResourceInner.class), (Type)((Object)JobResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<JobResourceInner>, JobResourceInner> beginUpdateAsync(String resourceGroupName, String jobName, JobResourceUpdateParameter jobResourceUpdateParameter) {
        String ifMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, jobName, jobResourceUpdateParameter, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)JobResourceInner.class), (Type)((Object)JobResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<JobResourceInner>, JobResourceInner> beginUpdateAsync(String resourceGroupName, String jobName, JobResourceUpdateParameter jobResourceUpdateParameter, String ifMatch, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, jobName, jobResourceUpdateParameter, ifMatch, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)JobResourceInner.class), (Type)((Object)JobResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<JobResourceInner>, JobResourceInner> beginUpdate(String resourceGroupName, String jobName, JobResourceUpdateParameter jobResourceUpdateParameter) {
        String ifMatch = null;
        return this.beginUpdateAsync(resourceGroupName, jobName, jobResourceUpdateParameter, ifMatch).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<JobResourceInner>, JobResourceInner> beginUpdate(String resourceGroupName, String jobName, JobResourceUpdateParameter jobResourceUpdateParameter, String ifMatch, Context context) {
        return this.beginUpdateAsync(resourceGroupName, jobName, jobResourceUpdateParameter, ifMatch, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JobResourceInner> updateAsync(String resourceGroupName, String jobName, JobResourceUpdateParameter jobResourceUpdateParameter, String ifMatch) {
        return this.beginUpdateAsync(resourceGroupName, jobName, jobResourceUpdateParameter, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JobResourceInner> updateAsync(String resourceGroupName, String jobName, JobResourceUpdateParameter jobResourceUpdateParameter) {
        String ifMatch = null;
        return this.beginUpdateAsync(resourceGroupName, jobName, jobResourceUpdateParameter, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JobResourceInner> updateAsync(String resourceGroupName, String jobName, JobResourceUpdateParameter jobResourceUpdateParameter, String ifMatch, Context context) {
        return this.beginUpdateAsync(resourceGroupName, jobName, jobResourceUpdateParameter, ifMatch, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobResourceInner update(String resourceGroupName, String jobName, JobResourceUpdateParameter jobResourceUpdateParameter) {
        String ifMatch = null;
        return (JobResourceInner)((Object)this.updateAsync(resourceGroupName, jobName, jobResourceUpdateParameter, ifMatch).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobResourceInner update(String resourceGroupName, String jobName, JobResourceUpdateParameter jobResourceUpdateParameter, String ifMatch, Context context) {
        return (JobResourceInner)((Object)this.updateAsync(resourceGroupName, jobName, jobResourceUpdateParameter, ifMatch, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ShipmentPickUpResponseInner>> bookShipmentPickUpWithResponseAsync(String resourceGroupName, String jobName, ShipmentPickUpRequest shipmentPickUpRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (shipmentPickUpRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter shipmentPickUpRequest is required and cannot be null."));
        }
        shipmentPickUpRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.bookShipmentPickUp(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, this.client.getApiVersion(), shipmentPickUpRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ShipmentPickUpResponseInner>> bookShipmentPickUpWithResponseAsync(String resourceGroupName, String jobName, ShipmentPickUpRequest shipmentPickUpRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (shipmentPickUpRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter shipmentPickUpRequest is required and cannot be null."));
        }
        shipmentPickUpRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.bookShipmentPickUp(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, this.client.getApiVersion(), shipmentPickUpRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ShipmentPickUpResponseInner> bookShipmentPickUpAsync(String resourceGroupName, String jobName, ShipmentPickUpRequest shipmentPickUpRequest) {
        return this.bookShipmentPickUpWithResponseAsync(resourceGroupName, jobName, shipmentPickUpRequest).flatMap(res -> Mono.justOrEmpty((Object)((ShipmentPickUpResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShipmentPickUpResponseInner> bookShipmentPickUpWithResponse(String resourceGroupName, String jobName, ShipmentPickUpRequest shipmentPickUpRequest, Context context) {
        return (Response)this.bookShipmentPickUpWithResponseAsync(resourceGroupName, jobName, shipmentPickUpRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShipmentPickUpResponseInner bookShipmentPickUp(String resourceGroupName, String jobName, ShipmentPickUpRequest shipmentPickUpRequest) {
        return (ShipmentPickUpResponseInner)this.bookShipmentPickUpWithResponse(resourceGroupName, jobName, shipmentPickUpRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> cancelWithResponseAsync(String resourceGroupName, String jobName, CancellationReason cancellationReason) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (cancellationReason == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cancellationReason is required and cannot be null."));
        }
        cancellationReason.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancel(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, this.client.getApiVersion(), cancellationReason, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> cancelWithResponseAsync(String resourceGroupName, String jobName, CancellationReason cancellationReason, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (cancellationReason == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cancellationReason is required and cannot be null."));
        }
        cancellationReason.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.cancel(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, this.client.getApiVersion(), cancellationReason, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> cancelAsync(String resourceGroupName, String jobName, CancellationReason cancellationReason) {
        return this.cancelWithResponseAsync(resourceGroupName, jobName, cancellationReason).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelWithResponse(String resourceGroupName, String jobName, CancellationReason cancellationReason, Context context) {
        return (Response)this.cancelWithResponseAsync(resourceGroupName, jobName, cancellationReason, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancel(String resourceGroupName, String jobName, CancellationReason cancellationReason) {
        this.cancelWithResponse(resourceGroupName, jobName, cancellationReason, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<UnencryptedCredentialsInner>> listCredentialsSinglePageAsync(String resourceGroupName, String jobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listCredentials(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UnencryptedCredentialsList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<UnencryptedCredentialsInner>> listCredentialsSinglePageAsync(String resourceGroupName, String jobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listCredentials(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UnencryptedCredentialsList)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<UnencryptedCredentialsInner> listCredentialsAsync(String resourceGroupName, String jobName) {
        return new PagedFlux(() -> this.listCredentialsSinglePageAsync(resourceGroupName, jobName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<UnencryptedCredentialsInner> listCredentialsAsync(String resourceGroupName, String jobName, Context context) {
        return new PagedFlux(() -> this.listCredentialsSinglePageAsync(resourceGroupName, jobName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<UnencryptedCredentialsInner> listCredentials(String resourceGroupName, String jobName) {
        return new PagedIterable(this.listCredentialsAsync(resourceGroupName, jobName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<UnencryptedCredentialsInner> listCredentials(String resourceGroupName, String jobName, Context context) {
        return new PagedIterable(this.listCredentialsAsync(resourceGroupName, jobName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobResourceList)res.getValue()).value(), ((JobResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobResourceList)res.getValue()).value(), ((JobResourceList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobResourceInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobResourceList)res.getValue()).value(), ((JobResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobResourceInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobResourceList)res.getValue()).value(), ((JobResourceList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataBoxManagementCli")
    public static interface JobsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/jobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobResourceList>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="$skipToken") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}/markDevicesShipped")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> markDevicesShipped(@HostParam(value="$host") String var1, @PathParam(value="jobName") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") MarkDevicesShippedRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobResourceList>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$skipToken") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobResourceInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="jobName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$expand") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="jobName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") JobResourceInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="jobName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="jobName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="If-Match") String var6, @BodyParam(value="application/json") JobResourceUpdateParameter var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}/bookShipmentPickUp")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ShipmentPickUpResponseInner>> bookShipmentPickUp(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="jobName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") ShipmentPickUpRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}/cancel")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> cancel(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="jobName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") CancellationReason var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}/listCredentials")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<UnencryptedCredentialsList>> listCredentials(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="jobName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobResourceList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobResourceList>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

