/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.databox.DataBoxManager;
import com.azure.resourcemanager.databox.fluent.models.JobResourceInner;
import com.azure.resourcemanager.databox.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.databox.models.CancellationReason;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.JobDeliveryInfo;
import com.azure.resourcemanager.databox.models.JobDeliveryType;
import com.azure.resourcemanager.databox.models.JobDetails;
import com.azure.resourcemanager.databox.models.JobResource;
import com.azure.resourcemanager.databox.models.JobResourceUpdateParameter;
import com.azure.resourcemanager.databox.models.MarkDevicesShippedRequest;
import com.azure.resourcemanager.databox.models.ResourceIdentity;
import com.azure.resourcemanager.databox.models.ReverseShippingDetailsEditStatus;
import com.azure.resourcemanager.databox.models.ReverseTransportPreferenceEditStatus;
import com.azure.resourcemanager.databox.models.ShipmentPickUpRequest;
import com.azure.resourcemanager.databox.models.ShipmentPickUpResponse;
import com.azure.resourcemanager.databox.models.Sku;
import com.azure.resourcemanager.databox.models.StageName;
import com.azure.resourcemanager.databox.models.TransferType;
import com.azure.resourcemanager.databox.models.UnencryptedCredentials;
import com.azure.resourcemanager.databox.models.UpdateJobDetails;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class JobResourceImpl
implements JobResource,
JobResource.Definition,
JobResource.Update {
    private JobResourceInner innerObject;
    private final DataBoxManager serviceManager;
    private String resourceGroupName;
    private String jobName;
    private String updateIfMatch;
    private JobResourceUpdateParameter updateJobResourceUpdateParameter;

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Sku sku() {
        return this.innerModel().sku();
    }

    @Override
    public ResourceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public TransferType transferType() {
        return this.innerModel().transferType();
    }

    @Override
    public Boolean isCancellable() {
        return this.innerModel().isCancellable();
    }

    @Override
    public Boolean isDeletable() {
        return this.innerModel().isDeletable();
    }

    @Override
    public Boolean isShippingAddressEditable() {
        return this.innerModel().isShippingAddressEditable();
    }

    @Override
    public ReverseShippingDetailsEditStatus reverseShippingDetailsUpdate() {
        return this.innerModel().reverseShippingDetailsUpdate();
    }

    @Override
    public ReverseTransportPreferenceEditStatus reverseTransportPreferenceUpdate() {
        return this.innerModel().reverseTransportPreferenceUpdate();
    }

    @Override
    public Boolean isPrepareToShipEnabled() {
        return this.innerModel().isPrepareToShipEnabled();
    }

    @Override
    public StageName status() {
        return this.innerModel().status();
    }

    @Override
    public StageName delayedStage() {
        return this.innerModel().delayedStage();
    }

    @Override
    public OffsetDateTime startTime() {
        return this.innerModel().startTime();
    }

    @Override
    public CloudError error() {
        return this.innerModel().error();
    }

    @Override
    public JobDetails details() {
        return this.innerModel().details();
    }

    @Override
    public String cancellationReason() {
        return this.innerModel().cancellationReason();
    }

    @Override
    public JobDeliveryType deliveryType() {
        return this.innerModel().deliveryType();
    }

    @Override
    public JobDeliveryInfo deliveryInfo() {
        return this.innerModel().deliveryInfo();
    }

    @Override
    public Boolean isCancellableWithoutFee() {
        return this.innerModel().isCancellableWithoutFee();
    }

    @Override
    public Boolean allDevicesLost() {
        return this.innerModel().allDevicesLost();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public JobResourceInner innerModel() {
        return this.innerObject;
    }

    private DataBoxManager manager() {
        return this.serviceManager;
    }

    @Override
    public JobResourceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public JobResource create() {
        this.innerObject = this.serviceManager.serviceClient().getJobs().create(this.resourceGroupName, this.jobName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public JobResource create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getJobs().create(this.resourceGroupName, this.jobName, this.innerModel(), context);
        return this;
    }

    JobResourceImpl(String name, DataBoxManager serviceManager) {
        this.innerObject = new JobResourceInner();
        this.serviceManager = serviceManager;
        this.jobName = name;
    }

    @Override
    public JobResourceImpl update() {
        this.updateIfMatch = null;
        this.updateJobResourceUpdateParameter = new JobResourceUpdateParameter();
        return this;
    }

    @Override
    public JobResource apply() {
        this.innerObject = this.serviceManager.serviceClient().getJobs().update(this.resourceGroupName, this.jobName, this.updateJobResourceUpdateParameter, this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public JobResource apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getJobs().update(this.resourceGroupName, this.jobName, this.updateJobResourceUpdateParameter, this.updateIfMatch, context);
        return this;
    }

    JobResourceImpl(JobResourceInner innerObject, DataBoxManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.jobName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "jobs");
    }

    @Override
    public JobResource refresh() {
        String localExpand = null;
        this.innerObject = (JobResourceInner)((Object)this.serviceManager.serviceClient().getJobs().getByResourceGroupWithResponse(this.resourceGroupName, this.jobName, localExpand, Context.NONE).getValue());
        return this;
    }

    @Override
    public JobResource refresh(Context context) {
        String localExpand = null;
        this.innerObject = (JobResourceInner)((Object)this.serviceManager.serviceClient().getJobs().getByResourceGroupWithResponse(this.resourceGroupName, this.jobName, localExpand, context).getValue());
        return this;
    }

    @Override
    public Response<Void> markDevicesShippedWithResponse(MarkDevicesShippedRequest markDevicesShippedRequest, Context context) {
        return this.serviceManager.jobs().markDevicesShippedWithResponse(this.jobName, this.resourceGroupName, markDevicesShippedRequest, context);
    }

    @Override
    public void markDevicesShipped(MarkDevicesShippedRequest markDevicesShippedRequest) {
        this.serviceManager.jobs().markDevicesShipped(this.jobName, this.resourceGroupName, markDevicesShippedRequest);
    }

    @Override
    public Response<ShipmentPickUpResponse> bookShipmentPickUpWithResponse(ShipmentPickUpRequest shipmentPickUpRequest, Context context) {
        return this.serviceManager.jobs().bookShipmentPickUpWithResponse(this.resourceGroupName, this.jobName, shipmentPickUpRequest, context);
    }

    @Override
    public ShipmentPickUpResponse bookShipmentPickUp(ShipmentPickUpRequest shipmentPickUpRequest) {
        return this.serviceManager.jobs().bookShipmentPickUp(this.resourceGroupName, this.jobName, shipmentPickUpRequest);
    }

    @Override
    public Response<Void> cancelWithResponse(CancellationReason cancellationReason, Context context) {
        return this.serviceManager.jobs().cancelWithResponse(this.resourceGroupName, this.jobName, cancellationReason, context);
    }

    @Override
    public void cancel(CancellationReason cancellationReason) {
        this.serviceManager.jobs().cancel(this.resourceGroupName, this.jobName, cancellationReason);
    }

    @Override
    public PagedIterable<UnencryptedCredentials> listCredentials() {
        return this.serviceManager.jobs().listCredentials(this.resourceGroupName, this.jobName);
    }

    @Override
    public PagedIterable<UnencryptedCredentials> listCredentials(Context context) {
        return this.serviceManager.jobs().listCredentials(this.resourceGroupName, this.jobName, context);
    }

    @Override
    public JobResourceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public JobResourceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public JobResourceImpl withSku(Sku sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    @Override
    public JobResourceImpl withTransferType(TransferType transferType) {
        this.innerModel().withTransferType(transferType);
        return this;
    }

    @Override
    public JobResourceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateJobResourceUpdateParameter.withTags(tags);
        return this;
    }

    @Override
    public JobResourceImpl withIdentity(ResourceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateJobResourceUpdateParameter.withIdentity(identity);
        return this;
    }

    @Override
    public JobResourceImpl withDetails(JobDetails details) {
        this.innerModel().withDetails(details);
        return this;
    }

    @Override
    public JobResourceImpl withDeliveryType(JobDeliveryType deliveryType) {
        this.innerModel().withDeliveryType(deliveryType);
        return this;
    }

    @Override
    public JobResourceImpl withDeliveryInfo(JobDeliveryInfo deliveryInfo) {
        this.innerModel().withDeliveryInfo(deliveryInfo);
        return this;
    }

    @Override
    public JobResourceImpl withDetails(UpdateJobDetails details) {
        this.updateJobResourceUpdateParameter.withDetails(details);
        return this;
    }

    @Override
    public JobResourceImpl withIfMatch(String ifMatch) {
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

