/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.OverallValidationStatus;
import com.azure.resourcemanager.databox.models.ValidationInputResponse;
import java.io.IOException;
import java.util.List;

public final class ValidationResponseProperties
implements JsonSerializable<ValidationResponseProperties> {
    private OverallValidationStatus status;
    private List<ValidationInputResponse> individualResponseDetails;

    public OverallValidationStatus status() {
        return this.status;
    }

    public List<ValidationInputResponse> individualResponseDetails() {
        return this.individualResponseDetails;
    }

    public void validate() {
        if (this.individualResponseDetails() != null) {
            this.individualResponseDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ValidationResponseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ValidationResponseProperties)jsonReader.readObject(reader -> {
            ValidationResponseProperties deserializedValidationResponseProperties = new ValidationResponseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedValidationResponseProperties.status = OverallValidationStatus.fromString(reader.getString());
                    continue;
                }
                if ("individualResponseDetails".equals(fieldName)) {
                    List individualResponseDetails;
                    deserializedValidationResponseProperties.individualResponseDetails = individualResponseDetails = reader.readArray(reader1 -> ValidationInputResponse.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidationResponseProperties;
        });
    }
}

