/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.DataLocationToServiceLocationMap;
import com.azure.resourcemanager.databox.models.SkuCapacity;
import com.azure.resourcemanager.databox.models.SkuCost;
import com.azure.resourcemanager.databox.models.SkuDisabledReason;
import java.io.IOException;
import java.util.List;

public final class SkuProperties
implements JsonSerializable<SkuProperties> {
    private List<DataLocationToServiceLocationMap> dataLocationToServiceLocationMap;
    private SkuCapacity capacity;
    private List<SkuCost> costs;
    private List<String> apiVersions;
    private SkuDisabledReason disabledReason;
    private String disabledReasonMessage;
    private String requiredFeature;
    private List<String> countriesWithinCommerceBoundary;

    public List<DataLocationToServiceLocationMap> dataLocationToServiceLocationMap() {
        return this.dataLocationToServiceLocationMap;
    }

    public SkuCapacity capacity() {
        return this.capacity;
    }

    public List<SkuCost> costs() {
        return this.costs;
    }

    public List<String> apiVersions() {
        return this.apiVersions;
    }

    public SkuDisabledReason disabledReason() {
        return this.disabledReason;
    }

    public String disabledReasonMessage() {
        return this.disabledReasonMessage;
    }

    public String requiredFeature() {
        return this.requiredFeature;
    }

    public List<String> countriesWithinCommerceBoundary() {
        return this.countriesWithinCommerceBoundary;
    }

    public void validate() {
        if (this.dataLocationToServiceLocationMap() != null) {
            this.dataLocationToServiceLocationMap().forEach(e -> e.validate());
        }
        if (this.capacity() != null) {
            this.capacity().validate();
        }
        if (this.costs() != null) {
            this.costs().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SkuProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SkuProperties)jsonReader.readObject(reader -> {
            SkuProperties deserializedSkuProperties = new SkuProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataLocationToServiceLocationMap".equals(fieldName)) {
                    List dataLocationToServiceLocationMap;
                    deserializedSkuProperties.dataLocationToServiceLocationMap = dataLocationToServiceLocationMap = reader.readArray(reader1 -> DataLocationToServiceLocationMap.fromJson(reader1));
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedSkuProperties.capacity = SkuCapacity.fromJson(reader);
                    continue;
                }
                if ("costs".equals(fieldName)) {
                    List costs;
                    deserializedSkuProperties.costs = costs = reader.readArray(reader1 -> SkuCost.fromJson(reader1));
                    continue;
                }
                if ("apiVersions".equals(fieldName)) {
                    List apiVersions;
                    deserializedSkuProperties.apiVersions = apiVersions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("disabledReason".equals(fieldName)) {
                    deserializedSkuProperties.disabledReason = SkuDisabledReason.fromString(reader.getString());
                    continue;
                }
                if ("disabledReasonMessage".equals(fieldName)) {
                    deserializedSkuProperties.disabledReasonMessage = reader.getString();
                    continue;
                }
                if ("requiredFeature".equals(fieldName)) {
                    deserializedSkuProperties.requiredFeature = reader.getString();
                    continue;
                }
                if ("countriesWithinCommerceBoundary".equals(fieldName)) {
                    List countriesWithinCommerceBoundary;
                    deserializedSkuProperties.countriesWithinCommerceBoundary = countriesWithinCommerceBoundary = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuProperties;
        });
    }
}

