/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.fluent.models.SkuProperties;
import com.azure.resourcemanager.databox.models.DataLocationToServiceLocationMap;
import com.azure.resourcemanager.databox.models.Sku;
import com.azure.resourcemanager.databox.models.SkuCapacity;
import com.azure.resourcemanager.databox.models.SkuCost;
import com.azure.resourcemanager.databox.models.SkuDisabledReason;
import java.io.IOException;
import java.util.List;

public final class SkuInformationInner
implements JsonSerializable<SkuInformationInner> {
    private Sku sku;
    private Boolean enabled;
    private SkuProperties innerProperties;

    public Sku sku() {
        return this.sku;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    private SkuProperties innerProperties() {
        return this.innerProperties;
    }

    public List<DataLocationToServiceLocationMap> dataLocationToServiceLocationMap() {
        return this.innerProperties() == null ? null : this.innerProperties().dataLocationToServiceLocationMap();
    }

    public SkuCapacity capacity() {
        return this.innerProperties() == null ? null : this.innerProperties().capacity();
    }

    public List<SkuCost> costs() {
        return this.innerProperties() == null ? null : this.innerProperties().costs();
    }

    public List<String> apiVersions() {
        return this.innerProperties() == null ? null : this.innerProperties().apiVersions();
    }

    public SkuDisabledReason disabledReason() {
        return this.innerProperties() == null ? null : this.innerProperties().disabledReason();
    }

    public String disabledReasonMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().disabledReasonMessage();
    }

    public String requiredFeature() {
        return this.innerProperties() == null ? null : this.innerProperties().requiredFeature();
    }

    public List<String> countriesWithinCommerceBoundary() {
        return this.innerProperties() == null ? null : this.innerProperties().countriesWithinCommerceBoundary();
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SkuInformationInner fromJson(JsonReader jsonReader) throws IOException {
        return (SkuInformationInner)jsonReader.readObject(reader -> {
            SkuInformationInner deserializedSkuInformationInner = new SkuInformationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedSkuInformationInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedSkuInformationInner.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSkuInformationInner.innerProperties = SkuProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuInformationInner;
        });
    }
}

