/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.fluent.models.JobProperties;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.JobDeliveryInfo;
import com.azure.resourcemanager.databox.models.JobDeliveryType;
import com.azure.resourcemanager.databox.models.JobDetails;
import com.azure.resourcemanager.databox.models.ResourceIdentity;
import com.azure.resourcemanager.databox.models.ReverseShippingDetailsEditStatus;
import com.azure.resourcemanager.databox.models.ReverseTransportPreferenceEditStatus;
import com.azure.resourcemanager.databox.models.Sku;
import com.azure.resourcemanager.databox.models.StageName;
import com.azure.resourcemanager.databox.models.TransferType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class JobResourceInner
extends Resource {
    private JobProperties innerProperties = new JobProperties();
    private String name;
    private String id;
    private String type;
    private SystemData systemData;
    private Sku sku;
    private ResourceIdentity identity;
    private static final ClientLogger LOGGER = new ClientLogger(JobResourceInner.class);

    private JobProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String type() {
        return this.type;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public Sku sku() {
        return this.sku;
    }

    public JobResourceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public ResourceIdentity identity() {
        return this.identity;
    }

    public JobResourceInner withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public JobResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public JobResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public TransferType transferType() {
        return this.innerProperties() == null ? null : this.innerProperties().transferType();
    }

    public JobResourceInner withTransferType(TransferType transferType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withTransferType(transferType);
        return this;
    }

    public Boolean isCancellable() {
        return this.innerProperties() == null ? null : this.innerProperties().isCancellable();
    }

    public Boolean isDeletable() {
        return this.innerProperties() == null ? null : this.innerProperties().isDeletable();
    }

    public Boolean isShippingAddressEditable() {
        return this.innerProperties() == null ? null : this.innerProperties().isShippingAddressEditable();
    }

    public ReverseShippingDetailsEditStatus reverseShippingDetailsUpdate() {
        return this.innerProperties() == null ? null : this.innerProperties().reverseShippingDetailsUpdate();
    }

    public ReverseTransportPreferenceEditStatus reverseTransportPreferenceUpdate() {
        return this.innerProperties() == null ? null : this.innerProperties().reverseTransportPreferenceUpdate();
    }

    public Boolean isPrepareToShipEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isPrepareToShipEnabled();
    }

    public StageName status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public StageName delayedStage() {
        return this.innerProperties() == null ? null : this.innerProperties().delayedStage();
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public CloudError error() {
        return this.innerProperties() == null ? null : this.innerProperties().error();
    }

    public JobDetails details() {
        return this.innerProperties() == null ? null : this.innerProperties().details();
    }

    public JobResourceInner withDetails(JobDetails details) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withDetails(details);
        return this;
    }

    public String cancellationReason() {
        return this.innerProperties() == null ? null : this.innerProperties().cancellationReason();
    }

    public JobDeliveryType deliveryType() {
        return this.innerProperties() == null ? null : this.innerProperties().deliveryType();
    }

    public JobResourceInner withDeliveryType(JobDeliveryType deliveryType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withDeliveryType(deliveryType);
        return this;
    }

    public JobDeliveryInfo deliveryInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().deliveryInfo();
    }

    public JobResourceInner withDeliveryInfo(JobDeliveryInfo deliveryInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withDeliveryInfo(deliveryInfo);
        return this;
    }

    public Boolean isCancellableWithoutFee() {
        return this.innerProperties() == null ? null : this.innerProperties().isCancellableWithoutFee();
    }

    public Boolean allDevicesLost() {
        return this.innerProperties() == null ? null : this.innerProperties().allDevicesLost();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model JobResourceInner"));
        }
        this.innerProperties().validate();
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model JobResourceInner"));
        }
        this.sku().validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static JobResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (JobResourceInner)((Object)jsonReader.readObject(reader -> {
            JobResourceInner deserializedJobResourceInner = new JobResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedJobResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedJobResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedJobResourceInner.innerProperties = JobProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedJobResourceInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedJobResourceInner.name = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedJobResourceInner.id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJobResourceInner.type = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedJobResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedJobResourceInner.identity = ResourceIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobResourceInner;
        }));
    }
}

