/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.databox.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.databox.models.CloudError;
import com.azure.resourcemanager.databox.models.JobDeliveryInfo;
import com.azure.resourcemanager.databox.models.JobDeliveryType;
import com.azure.resourcemanager.databox.models.JobDetails;
import com.azure.resourcemanager.databox.models.ReverseShippingDetailsEditStatus;
import com.azure.resourcemanager.databox.models.ReverseTransportPreferenceEditStatus;
import com.azure.resourcemanager.databox.models.StageName;
import com.azure.resourcemanager.databox.models.TransferType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class JobProperties
implements JsonSerializable<JobProperties> {
    private TransferType transferType;
    private Boolean isCancellable;
    private Boolean isDeletable;
    private Boolean isShippingAddressEditable;
    private ReverseShippingDetailsEditStatus reverseShippingDetailsUpdate;
    private ReverseTransportPreferenceEditStatus reverseTransportPreferenceUpdate;
    private Boolean isPrepareToShipEnabled;
    private StageName status;
    private StageName delayedStage;
    private OffsetDateTime startTime;
    private CloudError error;
    private JobDetails details;
    private String cancellationReason;
    private JobDeliveryType deliveryType;
    private JobDeliveryInfo deliveryInfo;
    private Boolean isCancellableWithoutFee;
    private Boolean allDevicesLost;
    private static final ClientLogger LOGGER = new ClientLogger(JobProperties.class);

    public TransferType transferType() {
        return this.transferType;
    }

    public JobProperties withTransferType(TransferType transferType) {
        this.transferType = transferType;
        return this;
    }

    public Boolean isCancellable() {
        return this.isCancellable;
    }

    public Boolean isDeletable() {
        return this.isDeletable;
    }

    public Boolean isShippingAddressEditable() {
        return this.isShippingAddressEditable;
    }

    public ReverseShippingDetailsEditStatus reverseShippingDetailsUpdate() {
        return this.reverseShippingDetailsUpdate;
    }

    public ReverseTransportPreferenceEditStatus reverseTransportPreferenceUpdate() {
        return this.reverseTransportPreferenceUpdate;
    }

    public Boolean isPrepareToShipEnabled() {
        return this.isPrepareToShipEnabled;
    }

    public StageName status() {
        return this.status;
    }

    public StageName delayedStage() {
        return this.delayedStage;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public CloudError error() {
        return this.error;
    }

    public JobDetails details() {
        return this.details;
    }

    public JobProperties withDetails(JobDetails details) {
        this.details = details;
        return this;
    }

    public String cancellationReason() {
        return this.cancellationReason;
    }

    public JobDeliveryType deliveryType() {
        return this.deliveryType;
    }

    public JobProperties withDeliveryType(JobDeliveryType deliveryType) {
        this.deliveryType = deliveryType;
        return this;
    }

    public JobDeliveryInfo deliveryInfo() {
        return this.deliveryInfo;
    }

    public JobProperties withDeliveryInfo(JobDeliveryInfo deliveryInfo) {
        this.deliveryInfo = deliveryInfo;
        return this;
    }

    public Boolean isCancellableWithoutFee() {
        return this.isCancellableWithoutFee;
    }

    public Boolean allDevicesLost() {
        return this.allDevicesLost;
    }

    public void validate() {
        if (this.transferType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property transferType in model JobProperties"));
        }
        if (this.error() != null) {
            this.error().validate();
        }
        if (this.details() != null) {
            this.details().validate();
        }
        if (this.deliveryInfo() != null) {
            this.deliveryInfo().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transferType", this.transferType == null ? null : this.transferType.toString());
        jsonWriter.writeJsonField("details", (JsonSerializable)this.details);
        jsonWriter.writeStringField("deliveryType", this.deliveryType == null ? null : this.deliveryType.toString());
        jsonWriter.writeJsonField("deliveryInfo", (JsonSerializable)this.deliveryInfo);
        return jsonWriter.writeEndObject();
    }

    public static JobProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobProperties)jsonReader.readObject(reader -> {
            JobProperties deserializedJobProperties = new JobProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transferType".equals(fieldName)) {
                    deserializedJobProperties.transferType = TransferType.fromString(reader.getString());
                    continue;
                }
                if ("isCancellable".equals(fieldName)) {
                    deserializedJobProperties.isCancellable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isDeletable".equals(fieldName)) {
                    deserializedJobProperties.isDeletable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isShippingAddressEditable".equals(fieldName)) {
                    deserializedJobProperties.isShippingAddressEditable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("reverseShippingDetailsUpdate".equals(fieldName)) {
                    deserializedJobProperties.reverseShippingDetailsUpdate = ReverseShippingDetailsEditStatus.fromString(reader.getString());
                    continue;
                }
                if ("reverseTransportPreferenceUpdate".equals(fieldName)) {
                    deserializedJobProperties.reverseTransportPreferenceUpdate = ReverseTransportPreferenceEditStatus.fromString(reader.getString());
                    continue;
                }
                if ("isPrepareToShipEnabled".equals(fieldName)) {
                    deserializedJobProperties.isPrepareToShipEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedJobProperties.status = StageName.fromString(reader.getString());
                    continue;
                }
                if ("delayedStage".equals(fieldName)) {
                    deserializedJobProperties.delayedStage = StageName.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedJobProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedJobProperties.error = CloudError.fromJson(reader);
                    continue;
                }
                if ("details".equals(fieldName)) {
                    deserializedJobProperties.details = JobDetails.fromJson(reader);
                    continue;
                }
                if ("cancellationReason".equals(fieldName)) {
                    deserializedJobProperties.cancellationReason = reader.getString();
                    continue;
                }
                if ("deliveryType".equals(fieldName)) {
                    deserializedJobProperties.deliveryType = JobDeliveryType.fromString(reader.getString());
                    continue;
                }
                if ("deliveryInfo".equals(fieldName)) {
                    deserializedJobProperties.deliveryInfo = JobDeliveryInfo.fromJson(reader);
                    continue;
                }
                if ("isCancellableWithoutFee".equals(fieldName)) {
                    deserializedJobProperties.isCancellableWithoutFee = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allDevicesLost".equals(fieldName)) {
                    deserializedJobProperties.allDevicesLost = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobProperties;
        });
    }
}

