/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dashboard.models.Size;
import java.io.IOException;

public final class ResourceSku
implements JsonSerializable<ResourceSku> {
    private String name;
    private Size size;

    public String name() {
        return this.name;
    }

    public ResourceSku withName(String name) {
        this.name = name;
        return this;
    }

    public Size size() {
        return this.size;
    }

    public ResourceSku withSize(Size size) {
        this.size = size;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("size", this.size == null ? null : this.size.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResourceSku fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceSku)jsonReader.readObject(reader -> {
            ResourceSku deserializedResourceSku = new ResourceSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedResourceSku.name = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedResourceSku.size = Size.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceSku;
        });
    }
}

