/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dashboard.models.ManagedGrafanaPropertiesUpdateParameters;
import com.azure.resourcemanager.dashboard.models.ManagedServiceIdentity;
import com.azure.resourcemanager.dashboard.models.ResourceSku;
import java.io.IOException;
import java.util.Map;

public final class ManagedGrafanaUpdateParameters
implements JsonSerializable<ManagedGrafanaUpdateParameters> {
    private ResourceSku sku;
    private ManagedServiceIdentity identity;
    private Map<String, String> tags;
    private ManagedGrafanaPropertiesUpdateParameters properties;

    public ResourceSku sku() {
        return this.sku;
    }

    public ManagedGrafanaUpdateParameters withSku(ResourceSku sku) {
        this.sku = sku;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ManagedGrafanaUpdateParameters withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ManagedGrafanaUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ManagedGrafanaPropertiesUpdateParameters properties() {
        return this.properties;
    }

    public ManagedGrafanaUpdateParameters withProperties(ManagedGrafanaPropertiesUpdateParameters properties) {
        this.properties = properties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ManagedGrafanaUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedGrafanaUpdateParameters)jsonReader.readObject(reader -> {
            ManagedGrafanaUpdateParameters deserializedManagedGrafanaUpdateParameters = new ManagedGrafanaUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedManagedGrafanaUpdateParameters.sku = ResourceSku.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedManagedGrafanaUpdateParameters.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedManagedGrafanaUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedGrafanaUpdateParameters.properties = ManagedGrafanaPropertiesUpdateParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedGrafanaUpdateParameters;
        });
    }
}

