/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dashboard.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.dashboard.models.ApiKey;
import com.azure.resourcemanager.dashboard.models.AutoGeneratedDomainNameLabelScope;
import com.azure.resourcemanager.dashboard.models.CreatorCanAdmin;
import com.azure.resourcemanager.dashboard.models.DeterministicOutboundIp;
import com.azure.resourcemanager.dashboard.models.EnterpriseConfigurations;
import com.azure.resourcemanager.dashboard.models.GrafanaConfigurations;
import com.azure.resourcemanager.dashboard.models.GrafanaIntegrations;
import com.azure.resourcemanager.dashboard.models.GrafanaPlugin;
import com.azure.resourcemanager.dashboard.models.ProvisioningState;
import com.azure.resourcemanager.dashboard.models.PublicNetworkAccess;
import com.azure.resourcemanager.dashboard.models.ZoneRedundancy;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ManagedGrafanaProperties
implements JsonSerializable<ManagedGrafanaProperties> {
    private ProvisioningState provisioningState;
    private String grafanaVersion;
    private String endpoint;
    private PublicNetworkAccess publicNetworkAccess;
    private ZoneRedundancy zoneRedundancy;
    private ApiKey apiKey;
    private CreatorCanAdmin creatorCanAdmin;
    private DeterministicOutboundIp deterministicOutboundIp;
    private List<String> outboundIPs;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope;
    private GrafanaIntegrations grafanaIntegrations;
    private EnterpriseConfigurations enterpriseConfigurations;
    private GrafanaConfigurations grafanaConfigurations;
    private Map<String, GrafanaPlugin> grafanaPlugins;
    private String grafanaMajorVersion;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String grafanaVersion() {
        return this.grafanaVersion;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ManagedGrafanaProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public ZoneRedundancy zoneRedundancy() {
        return this.zoneRedundancy;
    }

    public ManagedGrafanaProperties withZoneRedundancy(ZoneRedundancy zoneRedundancy) {
        this.zoneRedundancy = zoneRedundancy;
        return this;
    }

    public ApiKey apiKey() {
        return this.apiKey;
    }

    public ManagedGrafanaProperties withApiKey(ApiKey apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public CreatorCanAdmin creatorCanAdmin() {
        return this.creatorCanAdmin;
    }

    public ManagedGrafanaProperties withCreatorCanAdmin(CreatorCanAdmin creatorCanAdmin) {
        this.creatorCanAdmin = creatorCanAdmin;
        return this;
    }

    public DeterministicOutboundIp deterministicOutboundIp() {
        return this.deterministicOutboundIp;
    }

    public ManagedGrafanaProperties withDeterministicOutboundIp(DeterministicOutboundIp deterministicOutboundIp) {
        this.deterministicOutboundIp = deterministicOutboundIp;
        return this;
    }

    public List<String> outboundIPs() {
        return this.outboundIPs;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope() {
        return this.autoGeneratedDomainNameLabelScope;
    }

    public ManagedGrafanaProperties withAutoGeneratedDomainNameLabelScope(AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope) {
        this.autoGeneratedDomainNameLabelScope = autoGeneratedDomainNameLabelScope;
        return this;
    }

    public GrafanaIntegrations grafanaIntegrations() {
        return this.grafanaIntegrations;
    }

    public ManagedGrafanaProperties withGrafanaIntegrations(GrafanaIntegrations grafanaIntegrations) {
        this.grafanaIntegrations = grafanaIntegrations;
        return this;
    }

    public EnterpriseConfigurations enterpriseConfigurations() {
        return this.enterpriseConfigurations;
    }

    public ManagedGrafanaProperties withEnterpriseConfigurations(EnterpriseConfigurations enterpriseConfigurations) {
        this.enterpriseConfigurations = enterpriseConfigurations;
        return this;
    }

    public GrafanaConfigurations grafanaConfigurations() {
        return this.grafanaConfigurations;
    }

    public ManagedGrafanaProperties withGrafanaConfigurations(GrafanaConfigurations grafanaConfigurations) {
        this.grafanaConfigurations = grafanaConfigurations;
        return this;
    }

    public Map<String, GrafanaPlugin> grafanaPlugins() {
        return this.grafanaPlugins;
    }

    public ManagedGrafanaProperties withGrafanaPlugins(Map<String, GrafanaPlugin> grafanaPlugins) {
        this.grafanaPlugins = grafanaPlugins;
        return this;
    }

    public String grafanaMajorVersion() {
        return this.grafanaMajorVersion;
    }

    public ManagedGrafanaProperties withGrafanaMajorVersion(String grafanaMajorVersion) {
        this.grafanaMajorVersion = grafanaMajorVersion;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeStringField("zoneRedundancy", this.zoneRedundancy == null ? null : this.zoneRedundancy.toString());
        jsonWriter.writeStringField("apiKey", this.apiKey == null ? null : this.apiKey.toString());
        jsonWriter.writeStringField("creatorCanAdmin", this.creatorCanAdmin == null ? null : this.creatorCanAdmin.toString());
        jsonWriter.writeStringField("deterministicOutboundIP", this.deterministicOutboundIp == null ? null : this.deterministicOutboundIp.toString());
        jsonWriter.writeStringField("autoGeneratedDomainNameLabelScope", this.autoGeneratedDomainNameLabelScope == null ? null : this.autoGeneratedDomainNameLabelScope.toString());
        jsonWriter.writeJsonField("grafanaIntegrations", (JsonSerializable)this.grafanaIntegrations);
        jsonWriter.writeJsonField("enterpriseConfigurations", (JsonSerializable)this.enterpriseConfigurations);
        jsonWriter.writeJsonField("grafanaConfigurations", (JsonSerializable)this.grafanaConfigurations);
        jsonWriter.writeMapField("grafanaPlugins", this.grafanaPlugins, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("grafanaMajorVersion", this.grafanaMajorVersion);
        return jsonWriter.writeEndObject();
    }

    public static ManagedGrafanaProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedGrafanaProperties)jsonReader.readObject(reader -> {
            ManagedGrafanaProperties deserializedManagedGrafanaProperties = new ManagedGrafanaProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedGrafanaProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("grafanaVersion".equals(fieldName)) {
                    deserializedManagedGrafanaProperties.grafanaVersion = reader.getString();
                    continue;
                }
                if ("endpoint".equals(fieldName)) {
                    deserializedManagedGrafanaProperties.endpoint = reader.getString();
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedManagedGrafanaProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("zoneRedundancy".equals(fieldName)) {
                    deserializedManagedGrafanaProperties.zoneRedundancy = ZoneRedundancy.fromString(reader.getString());
                    continue;
                }
                if ("apiKey".equals(fieldName)) {
                    deserializedManagedGrafanaProperties.apiKey = ApiKey.fromString(reader.getString());
                    continue;
                }
                if ("creatorCanAdmin".equals(fieldName)) {
                    deserializedManagedGrafanaProperties.creatorCanAdmin = CreatorCanAdmin.fromString(reader.getString());
                    continue;
                }
                if ("deterministicOutboundIP".equals(fieldName)) {
                    deserializedManagedGrafanaProperties.deterministicOutboundIp = DeterministicOutboundIp.fromString(reader.getString());
                    continue;
                }
                if ("outboundIPs".equals(fieldName)) {
                    List outboundIPs;
                    deserializedManagedGrafanaProperties.outboundIPs = outboundIPs = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedManagedGrafanaProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("autoGeneratedDomainNameLabelScope".equals(fieldName)) {
                    deserializedManagedGrafanaProperties.autoGeneratedDomainNameLabelScope = AutoGeneratedDomainNameLabelScope.fromString(reader.getString());
                    continue;
                }
                if ("grafanaIntegrations".equals(fieldName)) {
                    deserializedManagedGrafanaProperties.grafanaIntegrations = GrafanaIntegrations.fromJson(reader);
                    continue;
                }
                if ("enterpriseConfigurations".equals(fieldName)) {
                    deserializedManagedGrafanaProperties.enterpriseConfigurations = EnterpriseConfigurations.fromJson(reader);
                    continue;
                }
                if ("grafanaConfigurations".equals(fieldName)) {
                    deserializedManagedGrafanaProperties.grafanaConfigurations = GrafanaConfigurations.fromJson(reader);
                    continue;
                }
                if ("grafanaPlugins".equals(fieldName)) {
                    Map grafanaPlugins;
                    deserializedManagedGrafanaProperties.grafanaPlugins = grafanaPlugins = reader.readMap(reader1 -> GrafanaPlugin.fromJson(reader1));
                    continue;
                }
                if ("grafanaMajorVersion".equals(fieldName)) {
                    deserializedManagedGrafanaProperties.grafanaMajorVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedGrafanaProperties;
        });
    }
}

