/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dashboard.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class IntegrationFabricProperties
implements JsonSerializable<IntegrationFabricProperties> {
    private ProvisioningState provisioningState;
    private String targetResourceId;
    private String dataSourceResourceId;
    private List<String> scenarios;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public IntegrationFabricProperties withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    public String dataSourceResourceId() {
        return this.dataSourceResourceId;
    }

    public IntegrationFabricProperties withDataSourceResourceId(String dataSourceResourceId) {
        this.dataSourceResourceId = dataSourceResourceId;
        return this;
    }

    public List<String> scenarios() {
        return this.scenarios;
    }

    public IntegrationFabricProperties withScenarios(List<String> scenarios) {
        this.scenarios = scenarios;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeStringField("dataSourceResourceId", this.dataSourceResourceId);
        jsonWriter.writeArrayField("scenarios", this.scenarios, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static IntegrationFabricProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IntegrationFabricProperties)jsonReader.readObject(reader -> {
            IntegrationFabricProperties deserializedIntegrationFabricProperties = new IntegrationFabricProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedIntegrationFabricProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("targetResourceId".equals(fieldName)) {
                    deserializedIntegrationFabricProperties.targetResourceId = reader.getString();
                    continue;
                }
                if ("dataSourceResourceId".equals(fieldName)) {
                    deserializedIntegrationFabricProperties.dataSourceResourceId = reader.getString();
                    continue;
                }
                if ("scenarios".equals(fieldName)) {
                    List scenarios;
                    deserializedIntegrationFabricProperties.scenarios = scenarios = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIntegrationFabricProperties;
        });
    }
}

