/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dashboard.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.dashboard.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.dashboard.implementation.DashboardManagementClientImpl;
import com.azure.resourcemanager.dashboard.implementation.models.PrivateEndpointConnectionListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PrivateEndpointConnectionsClientImpl
implements PrivateEndpointConnectionsClient {
    private final PrivateEndpointConnectionsService service;
    private final DashboardManagementClientImpl client;

    PrivateEndpointConnectionsClientImpl(DashboardManagementClientImpl client) {
        this.service = (PrivateEndpointConnectionsService)RestProxy.create(PrivateEndpointConnectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateEndpointConnectionInner>> getWithResponseAsync(String resourceGroupName, String workspaceName, String privateEndpointConnectionName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, privateEndpointConnectionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PrivateEndpointConnectionInner> getAsync(String resourceGroupName, String workspaceName, String privateEndpointConnectionName) {
        return this.getWithResponseAsync(resourceGroupName, workspaceName, privateEndpointConnectionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((PrivateEndpointConnectionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PrivateEndpointConnectionInner> getWithResponse(String resourceGroupName, String workspaceName, String privateEndpointConnectionName, Context context) {
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, privateEndpointConnectionName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateEndpointConnectionInner get(String resourceGroupName, String workspaceName, String privateEndpointConnectionName) {
        return (PrivateEndpointConnectionInner)((Object)this.getWithResponse(resourceGroupName, workspaceName, privateEndpointConnectionName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> approveWithResponseAsync(String resourceGroupName, String workspaceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.approve(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, privateEndpointConnectionName, "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> approveWithResponse(String resourceGroupName, String workspaceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner body) {
        String accept = "application/json";
        return this.service.approveSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, privateEndpointConnectionName, "application/json", body, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> approveWithResponse(String resourceGroupName, String workspaceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner body, Context context) {
        String accept = "application/json";
        return this.service.approveSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, privateEndpointConnectionName, "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginApproveAsync(String resourceGroupName, String workspaceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.approveWithResponseAsync(resourceGroupName, workspaceName, privateEndpointConnectionName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginApproveAsync(String resourceGroupName, String workspaceName, String privateEndpointConnectionName) {
        PrivateEndpointConnectionInner body = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.approveWithResponseAsync(resourceGroupName, workspaceName, privateEndpointConnectionName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginApprove(String resourceGroupName, String workspaceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner body) {
        Response<BinaryData> response = this.approveWithResponse(resourceGroupName, workspaceName, privateEndpointConnectionName, body);
        return this.client.getLroResult(response, (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginApprove(String resourceGroupName, String workspaceName, String privateEndpointConnectionName) {
        PrivateEndpointConnectionInner body = null;
        Response<BinaryData> response = this.approveWithResponse(resourceGroupName, workspaceName, privateEndpointConnectionName, body);
        return this.client.getLroResult(response, (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginApprove(String resourceGroupName, String workspaceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner body, Context context) {
        Response<BinaryData> response = this.approveWithResponse(resourceGroupName, workspaceName, privateEndpointConnectionName, body, context);
        return this.client.getLroResult(response, (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PrivateEndpointConnectionInner> approveAsync(String resourceGroupName, String workspaceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner body) {
        return this.beginApproveAsync(resourceGroupName, workspaceName, privateEndpointConnectionName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PrivateEndpointConnectionInner> approveAsync(String resourceGroupName, String workspaceName, String privateEndpointConnectionName) {
        PrivateEndpointConnectionInner body = null;
        return this.beginApproveAsync(resourceGroupName, workspaceName, privateEndpointConnectionName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateEndpointConnectionInner approve(String resourceGroupName, String workspaceName, String privateEndpointConnectionName) {
        PrivateEndpointConnectionInner body = null;
        return (PrivateEndpointConnectionInner)((Object)this.beginApprove(resourceGroupName, workspaceName, privateEndpointConnectionName, body).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateEndpointConnectionInner approve(String resourceGroupName, String workspaceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner body, Context context) {
        return (PrivateEndpointConnectionInner)((Object)this.beginApprove(resourceGroupName, workspaceName, privateEndpointConnectionName, body, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String workspaceName, String privateEndpointConnectionName) {
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, privateEndpointConnectionName, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String workspaceName, String privateEndpointConnectionName) {
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, privateEndpointConnectionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String workspaceName, String privateEndpointConnectionName, Context context) {
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, privateEndpointConnectionName, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String workspaceName, String privateEndpointConnectionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, workspaceName, privateEndpointConnectionName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String workspaceName, String privateEndpointConnectionName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, workspaceName, privateEndpointConnectionName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String workspaceName, String privateEndpointConnectionName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, workspaceName, privateEndpointConnectionName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String workspaceName, String privateEndpointConnectionName) {
        return this.beginDeleteAsync(resourceGroupName, workspaceName, privateEndpointConnectionName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String workspaceName, String privateEndpointConnectionName) {
        this.beginDelete(resourceGroupName, workspaceName, privateEndpointConnectionName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String workspaceName, String privateEndpointConnectionName, Context context) {
        this.beginDelete(resourceGroupName, workspaceName, privateEndpointConnectionName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateEndpointConnectionInner>> listSinglePageAsync(String resourceGroupName, String workspaceName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionListResult)res.getValue()).value(), ((PrivateEndpointConnectionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PrivateEndpointConnectionInner> listAsync(String resourceGroupName, String workspaceName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, workspaceName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PrivateEndpointConnectionInner> listSinglePage(String resourceGroupName, String workspaceName) {
        String accept = "application/json";
        Response<PrivateEndpointConnectionListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionListResult)res.getValue()).value(), ((PrivateEndpointConnectionListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PrivateEndpointConnectionInner> listSinglePage(String resourceGroupName, String workspaceName, Context context) {
        String accept = "application/json";
        Response<PrivateEndpointConnectionListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionListResult)res.getValue()).value(), ((PrivateEndpointConnectionListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PrivateEndpointConnectionInner> list(String resourceGroupName, String workspaceName) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, workspaceName), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PrivateEndpointConnectionInner> list(String resourceGroupName, String workspaceName, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, workspaceName, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateEndpointConnectionInner>> listNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionListResult)res.getValue()).value(), ((PrivateEndpointConnectionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PrivateEndpointConnectionInner> listNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<PrivateEndpointConnectionListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionListResult)res.getValue()).value(), ((PrivateEndpointConnectionListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PrivateEndpointConnectionInner> listNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<PrivateEndpointConnectionListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionListResult)res.getValue()).value(), ((PrivateEndpointConnectionListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DashboardManagementClientPrivateEndpointConnections")
    public static interface PrivateEndpointConnectionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateEndpointConnectionInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @PathParam(value="privateEndpointConnectionName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<PrivateEndpointConnectionInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @PathParam(value="privateEndpointConnectionName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> approve(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @PathParam(value="privateEndpointConnectionName") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") PrivateEndpointConnectionInner var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> approveSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @PathParam(value="privateEndpointConnectionName") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") PrivateEndpointConnectionInner var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @PathParam(value="privateEndpointConnectionName") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @PathParam(value="privateEndpointConnectionName") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/privateEndpointConnections")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateEndpointConnectionListResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/privateEndpointConnections")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<PrivateEndpointConnectionListResult> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateEndpointConnectionListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<PrivateEndpointConnectionListResult> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

