/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dashboard.fluent.ManagedPrivateEndpointsClient;
import com.azure.resourcemanager.dashboard.fluent.models.ManagedPrivateEndpointModelInner;
import com.azure.resourcemanager.dashboard.implementation.DashboardManagementClientImpl;
import com.azure.resourcemanager.dashboard.implementation.models.ManagedPrivateEndpointModelListResponse;
import com.azure.resourcemanager.dashboard.models.ManagedPrivateEndpointUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ManagedPrivateEndpointsClientImpl
implements ManagedPrivateEndpointsClient {
    private final ManagedPrivateEndpointsService service;
    private final DashboardManagementClientImpl client;

    ManagedPrivateEndpointsClientImpl(DashboardManagementClientImpl client) {
        this.service = (ManagedPrivateEndpointsService)RestProxy.create(ManagedPrivateEndpointsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> refreshWithResponseAsync(String resourceGroupName, String workspaceName) {
        return FluxUtil.withContext(context -> this.service.refresh(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> refreshWithResponse(String resourceGroupName, String workspaceName) {
        return this.service.refreshSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> refreshWithResponse(String resourceGroupName, String workspaceName, Context context) {
        return this.service.refreshSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRefreshAsync(String resourceGroupName, String workspaceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.refreshWithResponseAsync(resourceGroupName, workspaceName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRefresh(String resourceGroupName, String workspaceName) {
        Response<BinaryData> response = this.refreshWithResponse(resourceGroupName, workspaceName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRefresh(String resourceGroupName, String workspaceName, Context context) {
        Response<BinaryData> response = this.refreshWithResponse(resourceGroupName, workspaceName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> refreshAsync(String resourceGroupName, String workspaceName) {
        return this.beginRefreshAsync(resourceGroupName, workspaceName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void refresh(String resourceGroupName, String workspaceName) {
        this.beginRefresh(resourceGroupName, workspaceName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void refresh(String resourceGroupName, String workspaceName, Context context) {
        this.beginRefresh(resourceGroupName, workspaceName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ManagedPrivateEndpointModelInner>> getWithResponseAsync(String resourceGroupName, String workspaceName, String managedPrivateEndpointName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, managedPrivateEndpointName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedPrivateEndpointModelInner> getAsync(String resourceGroupName, String workspaceName, String managedPrivateEndpointName) {
        return this.getWithResponseAsync(resourceGroupName, workspaceName, managedPrivateEndpointName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ManagedPrivateEndpointModelInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ManagedPrivateEndpointModelInner> getWithResponse(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, Context context) {
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, managedPrivateEndpointName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedPrivateEndpointModelInner get(String resourceGroupName, String workspaceName, String managedPrivateEndpointName) {
        return (ManagedPrivateEndpointModelInner)((Object)this.getWithResponse(resourceGroupName, workspaceName, managedPrivateEndpointName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointModelInner requestBodyParameters) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, managedPrivateEndpointName, "application/json", "application/json", requestBodyParameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointModelInner requestBodyParameters) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, managedPrivateEndpointName, "application/json", "application/json", requestBodyParameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointModelInner requestBodyParameters, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, managedPrivateEndpointName, "application/json", "application/json", requestBodyParameters, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ManagedPrivateEndpointModelInner>, ManagedPrivateEndpointModelInner> beginCreateAsync(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointModelInner requestBodyParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, workspaceName, managedPrivateEndpointName, requestBodyParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ManagedPrivateEndpointModelInner.class), (Type)((Object)ManagedPrivateEndpointModelInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedPrivateEndpointModelInner>, ManagedPrivateEndpointModelInner> beginCreate(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointModelInner requestBodyParameters) {
        Response<BinaryData> response = this.createWithResponse(resourceGroupName, workspaceName, managedPrivateEndpointName, requestBodyParameters);
        return this.client.getLroResult(response, (Type)((Object)ManagedPrivateEndpointModelInner.class), (Type)((Object)ManagedPrivateEndpointModelInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedPrivateEndpointModelInner>, ManagedPrivateEndpointModelInner> beginCreate(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointModelInner requestBodyParameters, Context context) {
        Response<BinaryData> response = this.createWithResponse(resourceGroupName, workspaceName, managedPrivateEndpointName, requestBodyParameters, context);
        return this.client.getLroResult(response, (Type)((Object)ManagedPrivateEndpointModelInner.class), (Type)((Object)ManagedPrivateEndpointModelInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedPrivateEndpointModelInner> createAsync(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointModelInner requestBodyParameters) {
        return this.beginCreateAsync(resourceGroupName, workspaceName, managedPrivateEndpointName, requestBodyParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedPrivateEndpointModelInner create(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointModelInner requestBodyParameters) {
        return (ManagedPrivateEndpointModelInner)((Object)this.beginCreate(resourceGroupName, workspaceName, managedPrivateEndpointName, requestBodyParameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedPrivateEndpointModelInner create(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointModelInner requestBodyParameters, Context context) {
        return (ManagedPrivateEndpointModelInner)((Object)this.beginCreate(resourceGroupName, workspaceName, managedPrivateEndpointName, requestBodyParameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointUpdateParameters requestBodyParameters) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, managedPrivateEndpointName, "application/json", "application/json", requestBodyParameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointUpdateParameters requestBodyParameters) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, managedPrivateEndpointName, "application/json", "application/json", requestBodyParameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointUpdateParameters requestBodyParameters, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, managedPrivateEndpointName, "application/json", "application/json", requestBodyParameters, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ManagedPrivateEndpointModelInner>, ManagedPrivateEndpointModelInner> beginUpdateAsync(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointUpdateParameters requestBodyParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, workspaceName, managedPrivateEndpointName, requestBodyParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ManagedPrivateEndpointModelInner.class), (Type)((Object)ManagedPrivateEndpointModelInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedPrivateEndpointModelInner>, ManagedPrivateEndpointModelInner> beginUpdate(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointUpdateParameters requestBodyParameters) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, workspaceName, managedPrivateEndpointName, requestBodyParameters);
        return this.client.getLroResult(response, (Type)((Object)ManagedPrivateEndpointModelInner.class), (Type)((Object)ManagedPrivateEndpointModelInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedPrivateEndpointModelInner>, ManagedPrivateEndpointModelInner> beginUpdate(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointUpdateParameters requestBodyParameters, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, workspaceName, managedPrivateEndpointName, requestBodyParameters, context);
        return this.client.getLroResult(response, (Type)((Object)ManagedPrivateEndpointModelInner.class), (Type)((Object)ManagedPrivateEndpointModelInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedPrivateEndpointModelInner> updateAsync(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointUpdateParameters requestBodyParameters) {
        return this.beginUpdateAsync(resourceGroupName, workspaceName, managedPrivateEndpointName, requestBodyParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedPrivateEndpointModelInner update(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointUpdateParameters requestBodyParameters) {
        return (ManagedPrivateEndpointModelInner)((Object)this.beginUpdate(resourceGroupName, workspaceName, managedPrivateEndpointName, requestBodyParameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedPrivateEndpointModelInner update(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, ManagedPrivateEndpointUpdateParameters requestBodyParameters, Context context) {
        return (ManagedPrivateEndpointModelInner)((Object)this.beginUpdate(resourceGroupName, workspaceName, managedPrivateEndpointName, requestBodyParameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String workspaceName, String managedPrivateEndpointName) {
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, managedPrivateEndpointName, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String workspaceName, String managedPrivateEndpointName) {
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, managedPrivateEndpointName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, Context context) {
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, managedPrivateEndpointName, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String workspaceName, String managedPrivateEndpointName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, workspaceName, managedPrivateEndpointName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String workspaceName, String managedPrivateEndpointName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, workspaceName, managedPrivateEndpointName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, workspaceName, managedPrivateEndpointName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String workspaceName, String managedPrivateEndpointName) {
        return this.beginDeleteAsync(resourceGroupName, workspaceName, managedPrivateEndpointName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String workspaceName, String managedPrivateEndpointName) {
        this.beginDelete(resourceGroupName, workspaceName, managedPrivateEndpointName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, Context context) {
        this.beginDelete(resourceGroupName, workspaceName, managedPrivateEndpointName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedPrivateEndpointModelInner>> listSinglePageAsync(String resourceGroupName, String workspaceName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedPrivateEndpointModelListResponse)res.getValue()).value(), ((ManagedPrivateEndpointModelListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ManagedPrivateEndpointModelInner> listAsync(String resourceGroupName, String workspaceName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, workspaceName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedPrivateEndpointModelInner> listSinglePage(String resourceGroupName, String workspaceName) {
        String accept = "application/json";
        Response<ManagedPrivateEndpointModelListResponse> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedPrivateEndpointModelListResponse)res.getValue()).value(), ((ManagedPrivateEndpointModelListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedPrivateEndpointModelInner> listSinglePage(String resourceGroupName, String workspaceName, Context context) {
        String accept = "application/json";
        Response<ManagedPrivateEndpointModelListResponse> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedPrivateEndpointModelListResponse)res.getValue()).value(), ((ManagedPrivateEndpointModelListResponse)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedPrivateEndpointModelInner> list(String resourceGroupName, String workspaceName) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, workspaceName), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedPrivateEndpointModelInner> list(String resourceGroupName, String workspaceName, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, workspaceName, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedPrivateEndpointModelInner>> listNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedPrivateEndpointModelListResponse)res.getValue()).value(), ((ManagedPrivateEndpointModelListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedPrivateEndpointModelInner> listNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<ManagedPrivateEndpointModelListResponse> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedPrivateEndpointModelListResponse)res.getValue()).value(), ((ManagedPrivateEndpointModelListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedPrivateEndpointModelInner> listNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<ManagedPrivateEndpointModelListResponse> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedPrivateEndpointModelListResponse)res.getValue()).value(), ((ManagedPrivateEndpointModelListResponse)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DashboardManagementClientManagedPrivateEndpoints")
    public static interface ManagedPrivateEndpointsService {
        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/refreshManagedPrivateEndpoints")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> refresh(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/refreshManagedPrivateEndpoints")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> refreshSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/managedPrivateEndpoints/{managedPrivateEndpointName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedPrivateEndpointModelInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @PathParam(value="managedPrivateEndpointName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/managedPrivateEndpoints/{managedPrivateEndpointName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ManagedPrivateEndpointModelInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @PathParam(value="managedPrivateEndpointName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/managedPrivateEndpoints/{managedPrivateEndpointName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @PathParam(value="managedPrivateEndpointName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") ManagedPrivateEndpointModelInner var9, Context var10);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/managedPrivateEndpoints/{managedPrivateEndpointName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @PathParam(value="managedPrivateEndpointName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") ManagedPrivateEndpointModelInner var9, Context var10);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/managedPrivateEndpoints/{managedPrivateEndpointName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @PathParam(value="managedPrivateEndpointName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") ManagedPrivateEndpointUpdateParameters var9, Context var10);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/managedPrivateEndpoints/{managedPrivateEndpointName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @PathParam(value="managedPrivateEndpointName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") ManagedPrivateEndpointUpdateParameters var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/managedPrivateEndpoints/{managedPrivateEndpointName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @PathParam(value="managedPrivateEndpointName") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/managedPrivateEndpoints/{managedPrivateEndpointName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @PathParam(value="managedPrivateEndpointName") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/managedPrivateEndpoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedPrivateEndpointModelListResponse>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/managedPrivateEndpoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ManagedPrivateEndpointModelListResponse> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedPrivateEndpointModelListResponse>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ManagedPrivateEndpointModelListResponse> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

