/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dashboard.DashboardManager;
import com.azure.resourcemanager.dashboard.fluent.IntegrationFabricsClient;
import com.azure.resourcemanager.dashboard.fluent.models.IntegrationFabricInner;
import com.azure.resourcemanager.dashboard.implementation.IntegrationFabricImpl;
import com.azure.resourcemanager.dashboard.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dashboard.models.IntegrationFabric;
import com.azure.resourcemanager.dashboard.models.IntegrationFabrics;

public final class IntegrationFabricsImpl
implements IntegrationFabrics {
    private static final ClientLogger LOGGER = new ClientLogger(IntegrationFabricsImpl.class);
    private final IntegrationFabricsClient innerClient;
    private final DashboardManager serviceManager;

    public IntegrationFabricsImpl(IntegrationFabricsClient innerClient, DashboardManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<IntegrationFabric> getWithResponse(String resourceGroupName, String workspaceName, String integrationFabricName, Context context) {
        Response<IntegrationFabricInner> inner = this.serviceClient().getWithResponse(resourceGroupName, workspaceName, integrationFabricName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IntegrationFabricImpl((IntegrationFabricInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public IntegrationFabric get(String resourceGroupName, String workspaceName, String integrationFabricName) {
        IntegrationFabricInner inner = this.serviceClient().get(resourceGroupName, workspaceName, integrationFabricName);
        if (inner != null) {
            return new IntegrationFabricImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String workspaceName, String integrationFabricName) {
        this.serviceClient().delete(resourceGroupName, workspaceName, integrationFabricName);
    }

    @Override
    public void delete(String resourceGroupName, String workspaceName, String integrationFabricName, Context context) {
        this.serviceClient().delete(resourceGroupName, workspaceName, integrationFabricName, context);
    }

    @Override
    public PagedIterable<IntegrationFabric> list(String resourceGroupName, String workspaceName) {
        PagedIterable<IntegrationFabricInner> inner = this.serviceClient().list(resourceGroupName, workspaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IntegrationFabricImpl((IntegrationFabricInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IntegrationFabric> list(String resourceGroupName, String workspaceName, Context context) {
        PagedIterable<IntegrationFabricInner> inner = this.serviceClient().list(resourceGroupName, workspaceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IntegrationFabricImpl((IntegrationFabricInner)((Object)inner1), this.manager()));
    }

    @Override
    public IntegrationFabric getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "grafana");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'grafana'.", id)));
        }
        String integrationFabricName = ResourceManagerUtils.getValueFromIdByName(id, "integrationFabrics");
        if (integrationFabricName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'integrationFabrics'.", id)));
        }
        return (IntegrationFabric)this.getWithResponse(resourceGroupName, workspaceName, integrationFabricName, Context.NONE).getValue();
    }

    @Override
    public Response<IntegrationFabric> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "grafana");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'grafana'.", id)));
        }
        String integrationFabricName = ResourceManagerUtils.getValueFromIdByName(id, "integrationFabrics");
        if (integrationFabricName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'integrationFabrics'.", id)));
        }
        return this.getWithResponse(resourceGroupName, workspaceName, integrationFabricName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "grafana");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'grafana'.", id)));
        }
        String integrationFabricName = ResourceManagerUtils.getValueFromIdByName(id, "integrationFabrics");
        if (integrationFabricName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'integrationFabrics'.", id)));
        }
        this.delete(resourceGroupName, workspaceName, integrationFabricName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "grafana");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'grafana'.", id)));
        }
        String integrationFabricName = ResourceManagerUtils.getValueFromIdByName(id, "integrationFabrics");
        if (integrationFabricName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'integrationFabrics'.", id)));
        }
        this.delete(resourceGroupName, workspaceName, integrationFabricName, context);
    }

    private IntegrationFabricsClient serviceClient() {
        return this.innerClient;
    }

    private DashboardManager manager() {
        return this.serviceManager;
    }

    @Override
    public IntegrationFabricImpl define(String name) {
        return new IntegrationFabricImpl(name, this.manager());
    }
}

