/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dashboard.fluent.models.ManagedGrafanaInner;
import java.io.IOException;
import java.util.List;

public final class ManagedGrafanaListResponse
implements JsonSerializable<ManagedGrafanaListResponse> {
    private List<ManagedGrafanaInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedGrafanaListResponse.class);

    private ManagedGrafanaListResponse() {
    }

    public List<ManagedGrafanaInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ManagedGrafanaListResponse"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ManagedGrafanaListResponse fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedGrafanaListResponse)jsonReader.readObject(reader -> {
            ManagedGrafanaListResponse deserializedManagedGrafanaListResponse = new ManagedGrafanaListResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedManagedGrafanaListResponse.value = value = reader.readArray(reader1 -> ManagedGrafanaInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedManagedGrafanaListResponse.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedGrafanaListResponse;
        });
    }
}

