/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dashboard.DashboardManager;
import com.azure.resourcemanager.dashboard.fluent.models.ManagedPrivateEndpointModelInner;
import com.azure.resourcemanager.dashboard.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dashboard.models.ManagedPrivateEndpointConnectionState;
import com.azure.resourcemanager.dashboard.models.ManagedPrivateEndpointModel;
import com.azure.resourcemanager.dashboard.models.ManagedPrivateEndpointUpdateParameters;
import com.azure.resourcemanager.dashboard.models.ProvisioningState;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ManagedPrivateEndpointModelImpl
implements ManagedPrivateEndpointModel,
ManagedPrivateEndpointModel.Definition,
ManagedPrivateEndpointModel.Update {
    private ManagedPrivateEndpointModelInner innerObject;
    private final DashboardManager serviceManager;
    private String resourceGroupName;
    private String workspaceName;
    private String managedPrivateEndpointName;
    private ManagedPrivateEndpointUpdateParameters updateRequestBodyParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String privateLinkResourceId() {
        return this.innerModel().privateLinkResourceId();
    }

    @Override
    public String privateLinkResourceRegion() {
        return this.innerModel().privateLinkResourceRegion();
    }

    @Override
    public List<String> groupIds() {
        List<String> inner = this.innerModel().groupIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String requestMessage() {
        return this.innerModel().requestMessage();
    }

    @Override
    public ManagedPrivateEndpointConnectionState connectionState() {
        return this.innerModel().connectionState();
    }

    @Override
    public String privateLinkServiceUrl() {
        return this.innerModel().privateLinkServiceUrl();
    }

    @Override
    public String privateLinkServicePrivateIp() {
        return this.innerModel().privateLinkServicePrivateIp();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ManagedPrivateEndpointModelInner innerModel() {
        return this.innerObject;
    }

    private DashboardManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedPrivateEndpointModelImpl withExistingGrafana(String resourceGroupName, String workspaceName) {
        this.resourceGroupName = resourceGroupName;
        this.workspaceName = workspaceName;
        return this;
    }

    @Override
    public ManagedPrivateEndpointModel create() {
        this.innerObject = this.serviceManager.serviceClient().getManagedPrivateEndpoints().create(this.resourceGroupName, this.workspaceName, this.managedPrivateEndpointName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ManagedPrivateEndpointModel create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getManagedPrivateEndpoints().create(this.resourceGroupName, this.workspaceName, this.managedPrivateEndpointName, this.innerModel(), context);
        return this;
    }

    ManagedPrivateEndpointModelImpl(String name, DashboardManager serviceManager) {
        this.innerObject = new ManagedPrivateEndpointModelInner();
        this.serviceManager = serviceManager;
        this.managedPrivateEndpointName = name;
    }

    @Override
    public ManagedPrivateEndpointModelImpl update() {
        this.updateRequestBodyParameters = new ManagedPrivateEndpointUpdateParameters();
        return this;
    }

    @Override
    public ManagedPrivateEndpointModel apply() {
        this.innerObject = this.serviceManager.serviceClient().getManagedPrivateEndpoints().update(this.resourceGroupName, this.workspaceName, this.managedPrivateEndpointName, this.updateRequestBodyParameters, Context.NONE);
        return this;
    }

    @Override
    public ManagedPrivateEndpointModel apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getManagedPrivateEndpoints().update(this.resourceGroupName, this.workspaceName, this.managedPrivateEndpointName, this.updateRequestBodyParameters, context);
        return this;
    }

    ManagedPrivateEndpointModelImpl(ManagedPrivateEndpointModelInner innerObject, DashboardManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.workspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "grafana");
        this.managedPrivateEndpointName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedPrivateEndpoints");
    }

    @Override
    public ManagedPrivateEndpointModel refresh() {
        this.innerObject = (ManagedPrivateEndpointModelInner)((Object)this.serviceManager.serviceClient().getManagedPrivateEndpoints().getWithResponse(this.resourceGroupName, this.workspaceName, this.managedPrivateEndpointName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedPrivateEndpointModel refresh(Context context) {
        this.innerObject = (ManagedPrivateEndpointModelInner)((Object)this.serviceManager.serviceClient().getManagedPrivateEndpoints().getWithResponse(this.resourceGroupName, this.workspaceName, this.managedPrivateEndpointName, context).getValue());
        return this;
    }

    @Override
    public ManagedPrivateEndpointModelImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ManagedPrivateEndpointModelImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ManagedPrivateEndpointModelImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateRequestBodyParameters.withTags(tags);
        return this;
    }

    @Override
    public ManagedPrivateEndpointModelImpl withPrivateLinkResourceId(String privateLinkResourceId) {
        this.innerModel().withPrivateLinkResourceId(privateLinkResourceId);
        return this;
    }

    @Override
    public ManagedPrivateEndpointModelImpl withPrivateLinkResourceRegion(String privateLinkResourceRegion) {
        this.innerModel().withPrivateLinkResourceRegion(privateLinkResourceRegion);
        return this;
    }

    @Override
    public ManagedPrivateEndpointModelImpl withGroupIds(List<String> groupIds) {
        this.innerModel().withGroupIds(groupIds);
        return this;
    }

    @Override
    public ManagedPrivateEndpointModelImpl withRequestMessage(String requestMessage) {
        this.innerModel().withRequestMessage(requestMessage);
        return this;
    }

    @Override
    public ManagedPrivateEndpointModelImpl withPrivateLinkServiceUrl(String privateLinkServiceUrl) {
        this.innerModel().withPrivateLinkServiceUrl(privateLinkServiceUrl);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

