/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dashboard.fluent.models.ManagedPrivateEndpointModelProperties;
import com.azure.resourcemanager.dashboard.models.ManagedPrivateEndpointConnectionState;
import com.azure.resourcemanager.dashboard.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ManagedPrivateEndpointModelInner
extends Resource {
    private ManagedPrivateEndpointModelProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ManagedPrivateEndpointModelProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ManagedPrivateEndpointModelInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ManagedPrivateEndpointModelInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String privateLinkResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkResourceId();
    }

    public ManagedPrivateEndpointModelInner withPrivateLinkResourceId(String privateLinkResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedPrivateEndpointModelProperties();
        }
        this.innerProperties().withPrivateLinkResourceId(privateLinkResourceId);
        return this;
    }

    public String privateLinkResourceRegion() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkResourceRegion();
    }

    public ManagedPrivateEndpointModelInner withPrivateLinkResourceRegion(String privateLinkResourceRegion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedPrivateEndpointModelProperties();
        }
        this.innerProperties().withPrivateLinkResourceRegion(privateLinkResourceRegion);
        return this;
    }

    public List<String> groupIds() {
        return this.innerProperties() == null ? null : this.innerProperties().groupIds();
    }

    public ManagedPrivateEndpointModelInner withGroupIds(List<String> groupIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedPrivateEndpointModelProperties();
        }
        this.innerProperties().withGroupIds(groupIds);
        return this;
    }

    public String requestMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().requestMessage();
    }

    public ManagedPrivateEndpointModelInner withRequestMessage(String requestMessage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedPrivateEndpointModelProperties();
        }
        this.innerProperties().withRequestMessage(requestMessage);
        return this;
    }

    public ManagedPrivateEndpointConnectionState connectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionState();
    }

    public String privateLinkServiceUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceUrl();
    }

    public ManagedPrivateEndpointModelInner withPrivateLinkServiceUrl(String privateLinkServiceUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedPrivateEndpointModelProperties();
        }
        this.innerProperties().withPrivateLinkServiceUrl(privateLinkServiceUrl);
        return this;
    }

    public String privateLinkServicePrivateIp() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServicePrivateIp();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ManagedPrivateEndpointModelInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedPrivateEndpointModelInner)((Object)jsonReader.readObject(reader -> {
            ManagedPrivateEndpointModelInner deserializedManagedPrivateEndpointModelInner = new ManagedPrivateEndpointModelInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedPrivateEndpointModelInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedPrivateEndpointModelInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedPrivateEndpointModelInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedManagedPrivateEndpointModelInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedPrivateEndpointModelInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedPrivateEndpointModelInner.innerProperties = ManagedPrivateEndpointModelProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedManagedPrivateEndpointModelInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedPrivateEndpointModelInner;
        }));
    }
}

