/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dashboard.models.ManagedGrafanaProperties;
import com.azure.resourcemanager.dashboard.models.ManagedServiceIdentity;
import com.azure.resourcemanager.dashboard.models.ResourceSku;
import java.io.IOException;
import java.util.Map;

public final class ManagedGrafanaInner
extends Resource {
    private ResourceSku sku;
    private ManagedGrafanaProperties properties;
    private ManagedServiceIdentity identity;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ResourceSku sku() {
        return this.sku;
    }

    public ManagedGrafanaInner withSku(ResourceSku sku) {
        this.sku = sku;
        return this;
    }

    public ManagedGrafanaProperties properties() {
        return this.properties;
    }

    public ManagedGrafanaInner withProperties(ManagedGrafanaProperties properties) {
        this.properties = properties;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ManagedGrafanaInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ManagedGrafanaInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ManagedGrafanaInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static ManagedGrafanaInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedGrafanaInner)((Object)jsonReader.readObject(reader -> {
            ManagedGrafanaInner deserializedManagedGrafanaInner = new ManagedGrafanaInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedGrafanaInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedGrafanaInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedGrafanaInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedManagedGrafanaInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedGrafanaInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedManagedGrafanaInner.sku = ResourceSku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedGrafanaInner.properties = ManagedGrafanaProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedManagedGrafanaInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedManagedGrafanaInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedGrafanaInner;
        }));
    }
}

