/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.models.UpdateState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class UpdateStatus
implements JsonSerializable<UpdateStatus> {
    private OffsetDateTime startTime;
    private OffsetDateTime completedTime;
    private UpdateState state;
    private ManagementError error;

    private UpdateStatus() {
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime completedTime() {
        return this.completedTime;
    }

    public UpdateState state() {
        return this.state;
    }

    public ManagementError error() {
        return this.error;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static UpdateStatus fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateStatus)jsonReader.readObject(reader -> {
            UpdateStatus deserializedUpdateStatus = new UpdateStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedUpdateStatus.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("completedTime".equals(fieldName)) {
                    deserializedUpdateStatus.completedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedUpdateStatus.state = UpdateState.fromString(reader.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedUpdateStatus.error = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateStatus;
        });
    }
}

