/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.models.UpdateStage;
import java.io.IOException;
import java.util.List;

public final class UpdateRunStrategy
implements JsonSerializable<UpdateRunStrategy> {
    private List<UpdateStage> stages;
    private static final ClientLogger LOGGER = new ClientLogger(UpdateRunStrategy.class);

    public List<UpdateStage> stages() {
        return this.stages;
    }

    public UpdateRunStrategy withStages(List<UpdateStage> stages) {
        this.stages = stages;
        return this;
    }

    public void validate() {
        if (this.stages() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property stages in model UpdateRunStrategy"));
        }
        this.stages().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("stages", this.stages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static UpdateRunStrategy fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateRunStrategy)jsonReader.readObject(reader -> {
            UpdateRunStrategy deserializedUpdateRunStrategy = new UpdateRunStrategy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("stages".equals(fieldName)) {
                    List stages;
                    deserializedUpdateRunStrategy.stages = stages = reader.readArray(reader1 -> UpdateStage.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateRunStrategy;
        });
    }
}

