/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.models.NodeImageSelectionType;
import com.azure.resourcemanager.containerservicefleet.models.NodeImageVersion;
import java.io.IOException;
import java.util.List;

public final class NodeImageSelection
implements JsonSerializable<NodeImageSelection> {
    private NodeImageSelectionType type;
    private List<NodeImageVersion> customNodeImageVersions;
    private static final ClientLogger LOGGER = new ClientLogger(NodeImageSelection.class);

    public NodeImageSelectionType type() {
        return this.type;
    }

    public NodeImageSelection withType(NodeImageSelectionType type) {
        this.type = type;
        return this;
    }

    public List<NodeImageVersion> customNodeImageVersions() {
        return this.customNodeImageVersions;
    }

    public NodeImageSelection withCustomNodeImageVersions(List<NodeImageVersion> customNodeImageVersions) {
        this.customNodeImageVersions = customNodeImageVersions;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model NodeImageSelection"));
        }
        if (this.customNodeImageVersions() != null) {
            this.customNodeImageVersions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("customNodeImageVersions", this.customNodeImageVersions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static NodeImageSelection fromJson(JsonReader jsonReader) throws IOException {
        return (NodeImageSelection)jsonReader.readObject(reader -> {
            NodeImageSelection deserializedNodeImageSelection = new NodeImageSelection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedNodeImageSelection.type = NodeImageSelectionType.fromString(reader.getString());
                    continue;
                }
                if ("customNodeImageVersions".equals(fieldName)) {
                    List customNodeImageVersions;
                    deserializedNodeImageSelection.customNodeImageVersions = customNodeImageVersions = reader.readArray(reader1 -> NodeImageVersion.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNodeImageSelection;
        });
    }
}

