/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.models.ManagedClusterUpgradeSpec;
import com.azure.resourcemanager.containerservicefleet.models.NodeImageSelection;
import java.io.IOException;

public final class ManagedClusterUpdate
implements JsonSerializable<ManagedClusterUpdate> {
    private ManagedClusterUpgradeSpec upgrade;
    private NodeImageSelection nodeImageSelection;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterUpdate.class);

    public ManagedClusterUpgradeSpec upgrade() {
        return this.upgrade;
    }

    public ManagedClusterUpdate withUpgrade(ManagedClusterUpgradeSpec upgrade) {
        this.upgrade = upgrade;
        return this;
    }

    public NodeImageSelection nodeImageSelection() {
        return this.nodeImageSelection;
    }

    public ManagedClusterUpdate withNodeImageSelection(NodeImageSelection nodeImageSelection) {
        this.nodeImageSelection = nodeImageSelection;
        return this;
    }

    public void validate() {
        if (this.upgrade() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property upgrade in model ManagedClusterUpdate"));
        }
        this.upgrade().validate();
        if (this.nodeImageSelection() != null) {
            this.nodeImageSelection().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("upgrade", (JsonSerializable)this.upgrade);
        jsonWriter.writeJsonField("nodeImageSelection", (JsonSerializable)this.nodeImageSelection);
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedClusterUpdate)jsonReader.readObject(reader -> {
            ManagedClusterUpdate deserializedManagedClusterUpdate = new ManagedClusterUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("upgrade".equals(fieldName)) {
                    deserializedManagedClusterUpdate.upgrade = ManagedClusterUpgradeSpec.fromJson(reader);
                    continue;
                }
                if ("nodeImageSelection".equals(fieldName)) {
                    deserializedManagedClusterUpdate.nodeImageSelection = NodeImageSelection.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterUpdate;
        });
    }
}

