/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.models.AutoUpgradeLastTriggerStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class AutoUpgradeProfileStatus
implements JsonSerializable<AutoUpgradeProfileStatus> {
    private OffsetDateTime lastTriggeredAt;
    private AutoUpgradeLastTriggerStatus lastTriggerStatus;
    private ManagementError lastTriggerError;
    private List<String> lastTriggerUpgradeVersions;

    public OffsetDateTime lastTriggeredAt() {
        return this.lastTriggeredAt;
    }

    public AutoUpgradeLastTriggerStatus lastTriggerStatus() {
        return this.lastTriggerStatus;
    }

    public ManagementError lastTriggerError() {
        return this.lastTriggerError;
    }

    public List<String> lastTriggerUpgradeVersions() {
        return this.lastTriggerUpgradeVersions;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static AutoUpgradeProfileStatus fromJson(JsonReader jsonReader) throws IOException {
        return (AutoUpgradeProfileStatus)jsonReader.readObject(reader -> {
            AutoUpgradeProfileStatus deserializedAutoUpgradeProfileStatus = new AutoUpgradeProfileStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastTriggeredAt".equals(fieldName)) {
                    deserializedAutoUpgradeProfileStatus.lastTriggeredAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastTriggerStatus".equals(fieldName)) {
                    deserializedAutoUpgradeProfileStatus.lastTriggerStatus = AutoUpgradeLastTriggerStatus.fromString(reader.getString());
                    continue;
                }
                if ("lastTriggerError".equals(fieldName)) {
                    deserializedAutoUpgradeProfileStatus.lastTriggerError = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                if ("lastTriggerUpgradeVersions".equals(fieldName)) {
                    List lastTriggerUpgradeVersions;
                    deserializedAutoUpgradeProfileStatus.lastTriggerUpgradeVersions = lastTriggerUpgradeVersions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoUpgradeProfileStatus;
        });
    }
}

