/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.fluent.models.UpdateRunInner;
import java.io.IOException;
import java.util.List;

public final class UpdateRunListResult
implements JsonSerializable<UpdateRunListResult> {
    private List<UpdateRunInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(UpdateRunListResult.class);

    private UpdateRunListResult() {
    }

    public List<UpdateRunInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model UpdateRunListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static UpdateRunListResult fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateRunListResult)jsonReader.readObject(reader -> {
            UpdateRunListResult deserializedUpdateRunListResult = new UpdateRunListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedUpdateRunListResult.value = value = reader.readArray(reader1 -> UpdateRunInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedUpdateRunListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateRunListResult;
        });
    }
}

