/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservicefleet.ContainerServiceFleetManager;
import com.azure.resourcemanager.containerservicefleet.fluent.UpdateRunsClient;
import com.azure.resourcemanager.containerservicefleet.fluent.models.UpdateRunInner;
import com.azure.resourcemanager.containerservicefleet.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.containerservicefleet.implementation.UpdateRunImpl;
import com.azure.resourcemanager.containerservicefleet.models.SkipProperties;
import com.azure.resourcemanager.containerservicefleet.models.UpdateRun;
import com.azure.resourcemanager.containerservicefleet.models.UpdateRuns;

public final class UpdateRunsImpl
implements UpdateRuns {
    private static final ClientLogger LOGGER = new ClientLogger(UpdateRunsImpl.class);
    private final UpdateRunsClient innerClient;
    private final ContainerServiceFleetManager serviceManager;

    public UpdateRunsImpl(UpdateRunsClient innerClient, ContainerServiceFleetManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<UpdateRun> getWithResponse(String resourceGroupName, String fleetName, String updateRunName, Context context) {
        Response<UpdateRunInner> inner = this.serviceClient().getWithResponse(resourceGroupName, fleetName, updateRunName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new UpdateRunImpl((UpdateRunInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public UpdateRun get(String resourceGroupName, String fleetName, String updateRunName) {
        UpdateRunInner inner = this.serviceClient().get(resourceGroupName, fleetName, updateRunName);
        if (inner != null) {
            return new UpdateRunImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String fleetName, String updateRunName) {
        this.serviceClient().delete(resourceGroupName, fleetName, updateRunName);
    }

    @Override
    public void delete(String resourceGroupName, String fleetName, String updateRunName, String ifMatch, Context context) {
        this.serviceClient().delete(resourceGroupName, fleetName, updateRunName, ifMatch, context);
    }

    @Override
    public PagedIterable<UpdateRun> listByFleet(String resourceGroupName, String fleetName) {
        PagedIterable<UpdateRunInner> inner = this.serviceClient().listByFleet(resourceGroupName, fleetName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UpdateRunImpl((UpdateRunInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<UpdateRun> listByFleet(String resourceGroupName, String fleetName, Context context) {
        PagedIterable<UpdateRunInner> inner = this.serviceClient().listByFleet(resourceGroupName, fleetName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UpdateRunImpl((UpdateRunInner)((Object)inner1), this.manager()));
    }

    @Override
    public UpdateRun start(String resourceGroupName, String fleetName, String updateRunName) {
        UpdateRunInner inner = this.serviceClient().start(resourceGroupName, fleetName, updateRunName);
        if (inner != null) {
            return new UpdateRunImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public UpdateRun start(String resourceGroupName, String fleetName, String updateRunName, String ifMatch, Context context) {
        UpdateRunInner inner = this.serviceClient().start(resourceGroupName, fleetName, updateRunName, ifMatch, context);
        if (inner != null) {
            return new UpdateRunImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public UpdateRun stop(String resourceGroupName, String fleetName, String updateRunName) {
        UpdateRunInner inner = this.serviceClient().stop(resourceGroupName, fleetName, updateRunName);
        if (inner != null) {
            return new UpdateRunImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public UpdateRun stop(String resourceGroupName, String fleetName, String updateRunName, String ifMatch, Context context) {
        UpdateRunInner inner = this.serviceClient().stop(resourceGroupName, fleetName, updateRunName, ifMatch, context);
        if (inner != null) {
            return new UpdateRunImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public UpdateRun skip(String resourceGroupName, String fleetName, String updateRunName, SkipProperties body) {
        UpdateRunInner inner = this.serviceClient().skip(resourceGroupName, fleetName, updateRunName, body);
        if (inner != null) {
            return new UpdateRunImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public UpdateRun skip(String resourceGroupName, String fleetName, String updateRunName, SkipProperties body, String ifMatch, Context context) {
        UpdateRunInner inner = this.serviceClient().skip(resourceGroupName, fleetName, updateRunName, body, ifMatch, context);
        if (inner != null) {
            return new UpdateRunImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public UpdateRun getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String updateRunName = ResourceManagerUtils.getValueFromIdByName(id, "updateRuns");
        if (updateRunName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'updateRuns'.", id)));
        }
        return (UpdateRun)this.getWithResponse(resourceGroupName, fleetName, updateRunName, Context.NONE).getValue();
    }

    @Override
    public Response<UpdateRun> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String updateRunName = ResourceManagerUtils.getValueFromIdByName(id, "updateRuns");
        if (updateRunName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'updateRuns'.", id)));
        }
        return this.getWithResponse(resourceGroupName, fleetName, updateRunName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String updateRunName = ResourceManagerUtils.getValueFromIdByName(id, "updateRuns");
        if (updateRunName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'updateRuns'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, fleetName, updateRunName, localIfMatch, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String updateRunName = ResourceManagerUtils.getValueFromIdByName(id, "updateRuns");
        if (updateRunName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'updateRuns'.", id)));
        }
        this.delete(resourceGroupName, fleetName, updateRunName, ifMatch, context);
    }

    private UpdateRunsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerServiceFleetManager manager() {
        return this.serviceManager;
    }

    @Override
    public UpdateRunImpl define(String name) {
        return new UpdateRunImpl(name, this.manager());
    }
}

