/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.containerservicefleet.ContainerServiceFleetManager;
import com.azure.resourcemanager.containerservicefleet.fluent.models.UpdateRunInner;
import com.azure.resourcemanager.containerservicefleet.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.containerservicefleet.models.ManagedClusterUpdate;
import com.azure.resourcemanager.containerservicefleet.models.SkipProperties;
import com.azure.resourcemanager.containerservicefleet.models.UpdateRun;
import com.azure.resourcemanager.containerservicefleet.models.UpdateRunProvisioningState;
import com.azure.resourcemanager.containerservicefleet.models.UpdateRunStatus;
import com.azure.resourcemanager.containerservicefleet.models.UpdateRunStrategy;

public final class UpdateRunImpl
implements UpdateRun,
UpdateRun.Definition,
UpdateRun.Update {
    private UpdateRunInner innerObject;
    private final ContainerServiceFleetManager serviceManager;
    private String resourceGroupName;
    private String fleetName;
    private String updateRunName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private String updateIfNoneMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public UpdateRunProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String updateStrategyId() {
        return this.innerModel().updateStrategyId();
    }

    @Override
    public UpdateRunStrategy strategy() {
        return this.innerModel().strategy();
    }

    @Override
    public ManagedClusterUpdate managedClusterUpdate() {
        return this.innerModel().managedClusterUpdate();
    }

    @Override
    public UpdateRunStatus status() {
        return this.innerModel().status();
    }

    @Override
    public String autoUpgradeProfileId() {
        return this.innerModel().autoUpgradeProfileId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public UpdateRunInner innerModel() {
        return this.innerObject;
    }

    private ContainerServiceFleetManager manager() {
        return this.serviceManager;
    }

    @Override
    public UpdateRunImpl withExistingFleet(String resourceGroupName, String fleetName) {
        this.resourceGroupName = resourceGroupName;
        this.fleetName = fleetName;
        return this;
    }

    @Override
    public UpdateRun create() {
        this.innerObject = this.serviceManager.serviceClient().getUpdateRuns().createOrUpdate(this.resourceGroupName, this.fleetName, this.updateRunName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public UpdateRun create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getUpdateRuns().createOrUpdate(this.resourceGroupName, this.fleetName, this.updateRunName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    UpdateRunImpl(String name, ContainerServiceFleetManager serviceManager) {
        this.innerObject = new UpdateRunInner();
        this.serviceManager = serviceManager;
        this.updateRunName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public UpdateRunImpl update() {
        this.updateIfMatch = null;
        this.updateIfNoneMatch = null;
        return this;
    }

    @Override
    public UpdateRun apply() {
        this.innerObject = this.serviceManager.serviceClient().getUpdateRuns().createOrUpdate(this.resourceGroupName, this.fleetName, this.updateRunName, this.innerModel(), this.updateIfMatch, this.updateIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public UpdateRun apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getUpdateRuns().createOrUpdate(this.resourceGroupName, this.fleetName, this.updateRunName, this.innerModel(), this.updateIfMatch, this.updateIfNoneMatch, context);
        return this;
    }

    UpdateRunImpl(UpdateRunInner innerObject, ContainerServiceFleetManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.fleetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "fleets");
        this.updateRunName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "updateRuns");
    }

    @Override
    public UpdateRun refresh() {
        this.innerObject = (UpdateRunInner)((Object)this.serviceManager.serviceClient().getUpdateRuns().getWithResponse(this.resourceGroupName, this.fleetName, this.updateRunName, Context.NONE).getValue());
        return this;
    }

    @Override
    public UpdateRun refresh(Context context) {
        this.innerObject = (UpdateRunInner)((Object)this.serviceManager.serviceClient().getUpdateRuns().getWithResponse(this.resourceGroupName, this.fleetName, this.updateRunName, context).getValue());
        return this;
    }

    @Override
    public UpdateRun start() {
        return this.serviceManager.updateRuns().start(this.resourceGroupName, this.fleetName, this.updateRunName);
    }

    @Override
    public UpdateRun start(String ifMatch, Context context) {
        return this.serviceManager.updateRuns().start(this.resourceGroupName, this.fleetName, this.updateRunName, ifMatch, context);
    }

    @Override
    public UpdateRun stop() {
        return this.serviceManager.updateRuns().stop(this.resourceGroupName, this.fleetName, this.updateRunName);
    }

    @Override
    public UpdateRun stop(String ifMatch, Context context) {
        return this.serviceManager.updateRuns().stop(this.resourceGroupName, this.fleetName, this.updateRunName, ifMatch, context);
    }

    @Override
    public UpdateRun skip(SkipProperties body) {
        return this.serviceManager.updateRuns().skip(this.resourceGroupName, this.fleetName, this.updateRunName, body);
    }

    @Override
    public UpdateRun skip(SkipProperties body, String ifMatch, Context context) {
        return this.serviceManager.updateRuns().skip(this.resourceGroupName, this.fleetName, this.updateRunName, body, ifMatch, context);
    }

    @Override
    public UpdateRunImpl withUpdateStrategyId(String updateStrategyId) {
        this.innerModel().withUpdateStrategyId(updateStrategyId);
        return this;
    }

    @Override
    public UpdateRunImpl withStrategy(UpdateRunStrategy strategy) {
        this.innerModel().withStrategy(strategy);
        return this;
    }

    @Override
    public UpdateRunImpl withManagedClusterUpdate(ManagedClusterUpdate managedClusterUpdate) {
        this.innerModel().withManagedClusterUpdate(managedClusterUpdate);
        return this;
    }

    @Override
    public UpdateRunImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public UpdateRunImpl withIfNoneMatch(String ifNoneMatch) {
        if (this.isInCreateMode()) {
            this.createIfNoneMatch = ifNoneMatch;
            return this;
        }
        this.updateIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

