/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservicefleet.ContainerServiceFleetManager;
import com.azure.resourcemanager.containerservicefleet.fluent.FleetsClient;
import com.azure.resourcemanager.containerservicefleet.fluent.models.FleetCredentialResultsInner;
import com.azure.resourcemanager.containerservicefleet.fluent.models.FleetInner;
import com.azure.resourcemanager.containerservicefleet.implementation.FleetCredentialResultsImpl;
import com.azure.resourcemanager.containerservicefleet.implementation.FleetImpl;
import com.azure.resourcemanager.containerservicefleet.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.containerservicefleet.models.Fleet;
import com.azure.resourcemanager.containerservicefleet.models.FleetCredentialResults;
import com.azure.resourcemanager.containerservicefleet.models.Fleets;

public final class FleetsImpl
implements Fleets {
    private static final ClientLogger LOGGER = new ClientLogger(FleetsImpl.class);
    private final FleetsClient innerClient;
    private final ContainerServiceFleetManager serviceManager;

    public FleetsImpl(FleetsClient innerClient, ContainerServiceFleetManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Fleet> getByResourceGroupWithResponse(String resourceGroupName, String fleetName, Context context) {
        Response<FleetInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, fleetName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new FleetImpl((FleetInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Fleet getByResourceGroup(String resourceGroupName, String fleetName) {
        FleetInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, fleetName);
        if (inner != null) {
            return new FleetImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String fleetName) {
        this.serviceClient().delete(resourceGroupName, fleetName);
    }

    @Override
    public void delete(String resourceGroupName, String fleetName, String ifMatch, Context context) {
        this.serviceClient().delete(resourceGroupName, fleetName, ifMatch, context);
    }

    @Override
    public PagedIterable<Fleet> listByResourceGroup(String resourceGroupName) {
        PagedIterable<FleetInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FleetImpl((FleetInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Fleet> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<FleetInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FleetImpl((FleetInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Fleet> list() {
        PagedIterable<FleetInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FleetImpl((FleetInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Fleet> list(Context context) {
        PagedIterable<FleetInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FleetImpl((FleetInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<FleetCredentialResults> listCredentialsWithResponse(String resourceGroupName, String fleetName, Context context) {
        Response<FleetCredentialResultsInner> inner = this.serviceClient().listCredentialsWithResponse(resourceGroupName, fleetName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new FleetCredentialResultsImpl((FleetCredentialResultsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public FleetCredentialResults listCredentials(String resourceGroupName, String fleetName) {
        FleetCredentialResultsInner inner = this.serviceClient().listCredentials(resourceGroupName, fleetName);
        if (inner != null) {
            return new FleetCredentialResultsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Fleet getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        return (Fleet)this.getByResourceGroupWithResponse(resourceGroupName, fleetName, Context.NONE).getValue();
    }

    @Override
    public Response<Fleet> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, fleetName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, fleetName, localIfMatch, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        this.delete(resourceGroupName, fleetName, ifMatch, context);
    }

    private FleetsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerServiceFleetManager manager() {
        return this.serviceManager;
    }

    @Override
    public FleetImpl define(String name) {
        return new FleetImpl(name, this.manager());
    }
}

