/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.containerservicefleet.ContainerServiceFleetManager;
import com.azure.resourcemanager.containerservicefleet.fluent.models.FleetUpdateStrategyInner;
import com.azure.resourcemanager.containerservicefleet.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.containerservicefleet.models.FleetUpdateStrategy;
import com.azure.resourcemanager.containerservicefleet.models.FleetUpdateStrategyProvisioningState;
import com.azure.resourcemanager.containerservicefleet.models.UpdateRunStrategy;

public final class FleetUpdateStrategyImpl
implements FleetUpdateStrategy,
FleetUpdateStrategy.Definition,
FleetUpdateStrategy.Update {
    private FleetUpdateStrategyInner innerObject;
    private final ContainerServiceFleetManager serviceManager;
    private String resourceGroupName;
    private String fleetName;
    private String updateStrategyName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private String updateIfNoneMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public FleetUpdateStrategyProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public UpdateRunStrategy strategy() {
        return this.innerModel().strategy();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public FleetUpdateStrategyInner innerModel() {
        return this.innerObject;
    }

    private ContainerServiceFleetManager manager() {
        return this.serviceManager;
    }

    @Override
    public FleetUpdateStrategyImpl withExistingFleet(String resourceGroupName, String fleetName) {
        this.resourceGroupName = resourceGroupName;
        this.fleetName = fleetName;
        return this;
    }

    @Override
    public FleetUpdateStrategy create() {
        this.innerObject = this.serviceManager.serviceClient().getFleetUpdateStrategies().createOrUpdate(this.resourceGroupName, this.fleetName, this.updateStrategyName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public FleetUpdateStrategy create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getFleetUpdateStrategies().createOrUpdate(this.resourceGroupName, this.fleetName, this.updateStrategyName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    FleetUpdateStrategyImpl(String name, ContainerServiceFleetManager serviceManager) {
        this.innerObject = new FleetUpdateStrategyInner();
        this.serviceManager = serviceManager;
        this.updateStrategyName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public FleetUpdateStrategyImpl update() {
        this.updateIfMatch = null;
        this.updateIfNoneMatch = null;
        return this;
    }

    @Override
    public FleetUpdateStrategy apply() {
        this.innerObject = this.serviceManager.serviceClient().getFleetUpdateStrategies().createOrUpdate(this.resourceGroupName, this.fleetName, this.updateStrategyName, this.innerModel(), this.updateIfMatch, this.updateIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public FleetUpdateStrategy apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getFleetUpdateStrategies().createOrUpdate(this.resourceGroupName, this.fleetName, this.updateStrategyName, this.innerModel(), this.updateIfMatch, this.updateIfNoneMatch, context);
        return this;
    }

    FleetUpdateStrategyImpl(FleetUpdateStrategyInner innerObject, ContainerServiceFleetManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.fleetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "fleets");
        this.updateStrategyName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "updateStrategies");
    }

    @Override
    public FleetUpdateStrategy refresh() {
        this.innerObject = (FleetUpdateStrategyInner)((Object)this.serviceManager.serviceClient().getFleetUpdateStrategies().getWithResponse(this.resourceGroupName, this.fleetName, this.updateStrategyName, Context.NONE).getValue());
        return this;
    }

    @Override
    public FleetUpdateStrategy refresh(Context context) {
        this.innerObject = (FleetUpdateStrategyInner)((Object)this.serviceManager.serviceClient().getFleetUpdateStrategies().getWithResponse(this.resourceGroupName, this.fleetName, this.updateStrategyName, context).getValue());
        return this;
    }

    @Override
    public FleetUpdateStrategyImpl withStrategy(UpdateRunStrategy strategy) {
        this.innerModel().withStrategy(strategy);
        return this;
    }

    @Override
    public FleetUpdateStrategyImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public FleetUpdateStrategyImpl withIfNoneMatch(String ifNoneMatch) {
        if (this.isInCreateMode()) {
            this.createIfNoneMatch = ifNoneMatch;
            return this;
        }
        this.updateIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

