/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservicefleet.ContainerServiceFleetManager;
import com.azure.resourcemanager.containerservicefleet.fluent.AutoUpgradeProfilesClient;
import com.azure.resourcemanager.containerservicefleet.fluent.models.AutoUpgradeProfileInner;
import com.azure.resourcemanager.containerservicefleet.implementation.AutoUpgradeProfileImpl;
import com.azure.resourcemanager.containerservicefleet.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.containerservicefleet.models.AutoUpgradeProfile;
import com.azure.resourcemanager.containerservicefleet.models.AutoUpgradeProfiles;

public final class AutoUpgradeProfilesImpl
implements AutoUpgradeProfiles {
    private static final ClientLogger LOGGER = new ClientLogger(AutoUpgradeProfilesImpl.class);
    private final AutoUpgradeProfilesClient innerClient;
    private final ContainerServiceFleetManager serviceManager;

    public AutoUpgradeProfilesImpl(AutoUpgradeProfilesClient innerClient, ContainerServiceFleetManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<AutoUpgradeProfile> getWithResponse(String resourceGroupName, String fleetName, String autoUpgradeProfileName, Context context) {
        Response<AutoUpgradeProfileInner> inner = this.serviceClient().getWithResponse(resourceGroupName, fleetName, autoUpgradeProfileName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AutoUpgradeProfileImpl((AutoUpgradeProfileInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AutoUpgradeProfile get(String resourceGroupName, String fleetName, String autoUpgradeProfileName) {
        AutoUpgradeProfileInner inner = this.serviceClient().get(resourceGroupName, fleetName, autoUpgradeProfileName);
        if (inner != null) {
            return new AutoUpgradeProfileImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String fleetName, String autoUpgradeProfileName) {
        this.serviceClient().delete(resourceGroupName, fleetName, autoUpgradeProfileName);
    }

    @Override
    public void delete(String resourceGroupName, String fleetName, String autoUpgradeProfileName, String ifMatch, Context context) {
        this.serviceClient().delete(resourceGroupName, fleetName, autoUpgradeProfileName, ifMatch, context);
    }

    @Override
    public PagedIterable<AutoUpgradeProfile> listByFleet(String resourceGroupName, String fleetName) {
        PagedIterable<AutoUpgradeProfileInner> inner = this.serviceClient().listByFleet(resourceGroupName, fleetName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutoUpgradeProfileImpl((AutoUpgradeProfileInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AutoUpgradeProfile> listByFleet(String resourceGroupName, String fleetName, Context context) {
        PagedIterable<AutoUpgradeProfileInner> inner = this.serviceClient().listByFleet(resourceGroupName, fleetName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutoUpgradeProfileImpl((AutoUpgradeProfileInner)((Object)inner1), this.manager()));
    }

    @Override
    public AutoUpgradeProfile getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String autoUpgradeProfileName = ResourceManagerUtils.getValueFromIdByName(id, "autoUpgradeProfiles");
        if (autoUpgradeProfileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'autoUpgradeProfiles'.", id)));
        }
        return (AutoUpgradeProfile)this.getWithResponse(resourceGroupName, fleetName, autoUpgradeProfileName, Context.NONE).getValue();
    }

    @Override
    public Response<AutoUpgradeProfile> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String autoUpgradeProfileName = ResourceManagerUtils.getValueFromIdByName(id, "autoUpgradeProfiles");
        if (autoUpgradeProfileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'autoUpgradeProfiles'.", id)));
        }
        return this.getWithResponse(resourceGroupName, fleetName, autoUpgradeProfileName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String autoUpgradeProfileName = ResourceManagerUtils.getValueFromIdByName(id, "autoUpgradeProfiles");
        if (autoUpgradeProfileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'autoUpgradeProfiles'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, fleetName, autoUpgradeProfileName, localIfMatch, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String fleetName = ResourceManagerUtils.getValueFromIdByName(id, "fleets");
        if (fleetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'fleets'.", id)));
        }
        String autoUpgradeProfileName = ResourceManagerUtils.getValueFromIdByName(id, "autoUpgradeProfiles");
        if (autoUpgradeProfileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'autoUpgradeProfiles'.", id)));
        }
        this.delete(resourceGroupName, fleetName, autoUpgradeProfileName, ifMatch, context);
    }

    private AutoUpgradeProfilesClient serviceClient() {
        return this.innerClient;
    }

    private ContainerServiceFleetManager manager() {
        return this.serviceManager;
    }

    @Override
    public AutoUpgradeProfileImpl define(String name) {
        return new AutoUpgradeProfileImpl(name, this.manager());
    }
}

