/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservicefleet.ContainerServiceFleetManager;
import com.azure.resourcemanager.containerservicefleet.fluent.AutoUpgradeProfileOperationsClient;
import com.azure.resourcemanager.containerservicefleet.fluent.models.GenerateResponseInner;
import com.azure.resourcemanager.containerservicefleet.implementation.GenerateResponseImpl;
import com.azure.resourcemanager.containerservicefleet.models.AutoUpgradeProfileOperations;
import com.azure.resourcemanager.containerservicefleet.models.GenerateResponse;

public final class AutoUpgradeProfileOperationsImpl
implements AutoUpgradeProfileOperations {
    private static final ClientLogger LOGGER = new ClientLogger(AutoUpgradeProfileOperationsImpl.class);
    private final AutoUpgradeProfileOperationsClient innerClient;
    private final ContainerServiceFleetManager serviceManager;

    public AutoUpgradeProfileOperationsImpl(AutoUpgradeProfileOperationsClient innerClient, ContainerServiceFleetManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public GenerateResponse generateUpdateRun(String resourceGroupName, String fleetName, String autoUpgradeProfileName) {
        GenerateResponseInner inner = this.serviceClient().generateUpdateRun(resourceGroupName, fleetName, autoUpgradeProfileName);
        if (inner != null) {
            return new GenerateResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public GenerateResponse generateUpdateRun(String resourceGroupName, String fleetName, String autoUpgradeProfileName, Context context) {
        GenerateResponseInner inner = this.serviceClient().generateUpdateRun(resourceGroupName, fleetName, autoUpgradeProfileName, context);
        if (inner != null) {
            return new GenerateResponseImpl(inner, this.manager());
        }
        return null;
    }

    private AutoUpgradeProfileOperationsClient serviceClient() {
        return this.innerClient;
    }

    private ContainerServiceFleetManager manager() {
        return this.serviceManager;
    }
}

