/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerservicefleet.fluent.AutoUpgradeProfileOperationsClient;
import com.azure.resourcemanager.containerservicefleet.fluent.models.GenerateResponseInner;
import com.azure.resourcemanager.containerservicefleet.implementation.ContainerServiceFleetManagementClientImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AutoUpgradeProfileOperationsClientImpl
implements AutoUpgradeProfileOperationsClient {
    private final AutoUpgradeProfileOperationsService service;
    private final ContainerServiceFleetManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(AutoUpgradeProfileOperationsClientImpl.class);

    AutoUpgradeProfileOperationsClientImpl(ContainerServiceFleetManagementClientImpl client) {
        this.service = (AutoUpgradeProfileOperationsService)RestProxy.create(AutoUpgradeProfileOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> generateUpdateRunWithResponseAsync(String resourceGroupName, String fleetName, String autoUpgradeProfileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (autoUpgradeProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter autoUpgradeProfileName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.generateUpdateRun(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, fleetName, autoUpgradeProfileName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> generateUpdateRunWithResponse(String resourceGroupName, String fleetName, String autoUpgradeProfileName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (autoUpgradeProfileName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoUpgradeProfileName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.generateUpdateRunSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, fleetName, autoUpgradeProfileName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> generateUpdateRunWithResponse(String resourceGroupName, String fleetName, String autoUpgradeProfileName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (fleetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter fleetName is required and cannot be null."));
        }
        if (autoUpgradeProfileName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoUpgradeProfileName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.generateUpdateRunSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, fleetName, autoUpgradeProfileName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GenerateResponseInner>, GenerateResponseInner> beginGenerateUpdateRunAsync(String resourceGroupName, String fleetName, String autoUpgradeProfileName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.generateUpdateRunWithResponseAsync(resourceGroupName, fleetName, autoUpgradeProfileName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)GenerateResponseInner.class), (Type)((Object)GenerateResponseInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GenerateResponseInner>, GenerateResponseInner> beginGenerateUpdateRun(String resourceGroupName, String fleetName, String autoUpgradeProfileName) {
        Response<BinaryData> response = this.generateUpdateRunWithResponse(resourceGroupName, fleetName, autoUpgradeProfileName);
        return this.client.getLroResult(response, (Type)((Object)GenerateResponseInner.class), (Type)((Object)GenerateResponseInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GenerateResponseInner>, GenerateResponseInner> beginGenerateUpdateRun(String resourceGroupName, String fleetName, String autoUpgradeProfileName, Context context) {
        Response<BinaryData> response = this.generateUpdateRunWithResponse(resourceGroupName, fleetName, autoUpgradeProfileName, context);
        return this.client.getLroResult(response, (Type)((Object)GenerateResponseInner.class), (Type)((Object)GenerateResponseInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GenerateResponseInner> generateUpdateRunAsync(String resourceGroupName, String fleetName, String autoUpgradeProfileName) {
        return this.beginGenerateUpdateRunAsync(resourceGroupName, fleetName, autoUpgradeProfileName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenerateResponseInner generateUpdateRun(String resourceGroupName, String fleetName, String autoUpgradeProfileName) {
        return (GenerateResponseInner)this.beginGenerateUpdateRun(resourceGroupName, fleetName, autoUpgradeProfileName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenerateResponseInner generateUpdateRun(String resourceGroupName, String fleetName, String autoUpgradeProfileName, Context context) {
        return (GenerateResponseInner)this.beginGenerateUpdateRun(resourceGroupName, fleetName, autoUpgradeProfileName, context).getFinalResult();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ContainerServiceFlee")
    public static interface AutoUpgradeProfileOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/autoUpgradeProfiles/{autoUpgradeProfileName}/generateUpdateRun")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> generateUpdateRun(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="fleetName") String var5, @PathParam(value="autoUpgradeProfileName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/autoUpgradeProfiles/{autoUpgradeProfileName}/generateUpdateRun")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> generateUpdateRunSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="fleetName") String var5, @PathParam(value="autoUpgradeProfileName") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

