/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.fluent.models.UpdateRunProperties;
import com.azure.resourcemanager.containerservicefleet.models.ManagedClusterUpdate;
import com.azure.resourcemanager.containerservicefleet.models.UpdateRunProvisioningState;
import com.azure.resourcemanager.containerservicefleet.models.UpdateRunStatus;
import com.azure.resourcemanager.containerservicefleet.models.UpdateRunStrategy;
import java.io.IOException;

public final class UpdateRunInner
extends ProxyResource {
    private UpdateRunProperties innerProperties;
    private String etag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private UpdateRunProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public UpdateRunProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String updateStrategyId() {
        return this.innerProperties() == null ? null : this.innerProperties().updateStrategyId();
    }

    public UpdateRunInner withUpdateStrategyId(String updateStrategyId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UpdateRunProperties();
        }
        this.innerProperties().withUpdateStrategyId(updateStrategyId);
        return this;
    }

    public UpdateRunStrategy strategy() {
        return this.innerProperties() == null ? null : this.innerProperties().strategy();
    }

    public UpdateRunInner withStrategy(UpdateRunStrategy strategy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UpdateRunProperties();
        }
        this.innerProperties().withStrategy(strategy);
        return this;
    }

    public ManagedClusterUpdate managedClusterUpdate() {
        return this.innerProperties() == null ? null : this.innerProperties().managedClusterUpdate();
    }

    public UpdateRunInner withManagedClusterUpdate(ManagedClusterUpdate managedClusterUpdate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UpdateRunProperties();
        }
        this.innerProperties().withManagedClusterUpdate(managedClusterUpdate);
        return this;
    }

    public UpdateRunStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public String autoUpgradeProfileId() {
        return this.innerProperties() == null ? null : this.innerProperties().autoUpgradeProfileId();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static UpdateRunInner fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateRunInner)((Object)jsonReader.readObject(reader -> {
            UpdateRunInner deserializedUpdateRunInner = new UpdateRunInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedUpdateRunInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedUpdateRunInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedUpdateRunInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedUpdateRunInner.innerProperties = UpdateRunProperties.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedUpdateRunInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedUpdateRunInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateRunInner;
        }));
    }
}

