/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.models.FleetHubProfile;
import com.azure.resourcemanager.containerservicefleet.models.FleetProvisioningState;
import com.azure.resourcemanager.containerservicefleet.models.FleetStatus;
import java.io.IOException;

public final class FleetProperties
implements JsonSerializable<FleetProperties> {
    private FleetProvisioningState provisioningState;
    private FleetHubProfile hubProfile;
    private FleetStatus status;

    public FleetProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public FleetHubProfile hubProfile() {
        return this.hubProfile;
    }

    public FleetProperties withHubProfile(FleetHubProfile hubProfile) {
        this.hubProfile = hubProfile;
        return this;
    }

    public FleetStatus status() {
        return this.status;
    }

    public void validate() {
        if (this.hubProfile() != null) {
            this.hubProfile().validate();
        }
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("hubProfile", (JsonSerializable)this.hubProfile);
        return jsonWriter.writeEndObject();
    }

    public static FleetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FleetProperties)jsonReader.readObject(reader -> {
            FleetProperties deserializedFleetProperties = new FleetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedFleetProperties.provisioningState = FleetProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("hubProfile".equals(fieldName)) {
                    deserializedFleetProperties.hubProfile = FleetHubProfile.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedFleetProperties.status = FleetStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFleetProperties;
        });
    }
}

