/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservicefleet.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservicefleet.fluent.models.FleetProperties;
import com.azure.resourcemanager.containerservicefleet.models.FleetHubProfile;
import com.azure.resourcemanager.containerservicefleet.models.FleetProvisioningState;
import com.azure.resourcemanager.containerservicefleet.models.FleetStatus;
import com.azure.resourcemanager.containerservicefleet.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.Map;

public final class FleetInner
extends Resource {
    private FleetProperties innerProperties;
    private String etag;
    private ManagedServiceIdentity identity;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private FleetProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public FleetInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public FleetInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public FleetInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public FleetProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public FleetHubProfile hubProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().hubProfile();
    }

    public FleetInner withHubProfile(FleetHubProfile hubProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetProperties();
        }
        this.innerProperties().withHubProfile(hubProfile);
        return this;
    }

    public FleetStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static FleetInner fromJson(JsonReader jsonReader) throws IOException {
        return (FleetInner)((Object)jsonReader.readObject(reader -> {
            FleetInner deserializedFleetInner = new FleetInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedFleetInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFleetInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFleetInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedFleetInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedFleetInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedFleetInner.innerProperties = FleetProperties.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedFleetInner.etag = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedFleetInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedFleetInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFleetInner;
        }));
    }
}

