/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class KubeletConfig
implements JsonSerializable<KubeletConfig> {
    private String cpuManagerPolicy;
    private Boolean cpuCfsQuota;
    private String cpuCfsQuotaPeriod;
    private Integer imageGcHighThreshold;
    private Integer imageGcLowThreshold;
    private String topologyManagerPolicy;
    private List<String> allowedUnsafeSysctls;
    private Boolean failSwapOn;
    private Integer containerLogMaxSizeMB;
    private Integer containerLogMaxFiles;
    private Integer podMaxPids;

    public String cpuManagerPolicy() {
        return this.cpuManagerPolicy;
    }

    public KubeletConfig withCpuManagerPolicy(String cpuManagerPolicy) {
        this.cpuManagerPolicy = cpuManagerPolicy;
        return this;
    }

    public Boolean cpuCfsQuota() {
        return this.cpuCfsQuota;
    }

    public KubeletConfig withCpuCfsQuota(Boolean cpuCfsQuota) {
        this.cpuCfsQuota = cpuCfsQuota;
        return this;
    }

    public String cpuCfsQuotaPeriod() {
        return this.cpuCfsQuotaPeriod;
    }

    public KubeletConfig withCpuCfsQuotaPeriod(String cpuCfsQuotaPeriod) {
        this.cpuCfsQuotaPeriod = cpuCfsQuotaPeriod;
        return this;
    }

    public Integer imageGcHighThreshold() {
        return this.imageGcHighThreshold;
    }

    public KubeletConfig withImageGcHighThreshold(Integer imageGcHighThreshold) {
        this.imageGcHighThreshold = imageGcHighThreshold;
        return this;
    }

    public Integer imageGcLowThreshold() {
        return this.imageGcLowThreshold;
    }

    public KubeletConfig withImageGcLowThreshold(Integer imageGcLowThreshold) {
        this.imageGcLowThreshold = imageGcLowThreshold;
        return this;
    }

    public String topologyManagerPolicy() {
        return this.topologyManagerPolicy;
    }

    public KubeletConfig withTopologyManagerPolicy(String topologyManagerPolicy) {
        this.topologyManagerPolicy = topologyManagerPolicy;
        return this;
    }

    public List<String> allowedUnsafeSysctls() {
        return this.allowedUnsafeSysctls;
    }

    public KubeletConfig withAllowedUnsafeSysctls(List<String> allowedUnsafeSysctls) {
        this.allowedUnsafeSysctls = allowedUnsafeSysctls;
        return this;
    }

    public Boolean failSwapOn() {
        return this.failSwapOn;
    }

    public KubeletConfig withFailSwapOn(Boolean failSwapOn) {
        this.failSwapOn = failSwapOn;
        return this;
    }

    public Integer containerLogMaxSizeMB() {
        return this.containerLogMaxSizeMB;
    }

    public KubeletConfig withContainerLogMaxSizeMB(Integer containerLogMaxSizeMB) {
        this.containerLogMaxSizeMB = containerLogMaxSizeMB;
        return this;
    }

    public Integer containerLogMaxFiles() {
        return this.containerLogMaxFiles;
    }

    public KubeletConfig withContainerLogMaxFiles(Integer containerLogMaxFiles) {
        this.containerLogMaxFiles = containerLogMaxFiles;
        return this;
    }

    public Integer podMaxPids() {
        return this.podMaxPids;
    }

    public KubeletConfig withPodMaxPids(Integer podMaxPids) {
        this.podMaxPids = podMaxPids;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("cpuManagerPolicy", this.cpuManagerPolicy);
        jsonWriter.writeBooleanField("cpuCfsQuota", this.cpuCfsQuota);
        jsonWriter.writeStringField("cpuCfsQuotaPeriod", this.cpuCfsQuotaPeriod);
        jsonWriter.writeNumberField("imageGcHighThreshold", (Number)this.imageGcHighThreshold);
        jsonWriter.writeNumberField("imageGcLowThreshold", (Number)this.imageGcLowThreshold);
        jsonWriter.writeStringField("topologyManagerPolicy", this.topologyManagerPolicy);
        jsonWriter.writeArrayField("allowedUnsafeSysctls", this.allowedUnsafeSysctls, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("failSwapOn", this.failSwapOn);
        jsonWriter.writeNumberField("containerLogMaxSizeMB", (Number)this.containerLogMaxSizeMB);
        jsonWriter.writeNumberField("containerLogMaxFiles", (Number)this.containerLogMaxFiles);
        jsonWriter.writeNumberField("podMaxPids", (Number)this.podMaxPids);
        return jsonWriter.writeEndObject();
    }

    public static KubeletConfig fromJson(JsonReader jsonReader) throws IOException {
        return (KubeletConfig)jsonReader.readObject(reader -> {
            KubeletConfig deserializedKubeletConfig = new KubeletConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cpuManagerPolicy".equals(fieldName)) {
                    deserializedKubeletConfig.cpuManagerPolicy = reader.getString();
                    continue;
                }
                if ("cpuCfsQuota".equals(fieldName)) {
                    deserializedKubeletConfig.cpuCfsQuota = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("cpuCfsQuotaPeriod".equals(fieldName)) {
                    deserializedKubeletConfig.cpuCfsQuotaPeriod = reader.getString();
                    continue;
                }
                if ("imageGcHighThreshold".equals(fieldName)) {
                    deserializedKubeletConfig.imageGcHighThreshold = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("imageGcLowThreshold".equals(fieldName)) {
                    deserializedKubeletConfig.imageGcLowThreshold = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("topologyManagerPolicy".equals(fieldName)) {
                    deserializedKubeletConfig.topologyManagerPolicy = reader.getString();
                    continue;
                }
                if ("allowedUnsafeSysctls".equals(fieldName)) {
                    List allowedUnsafeSysctls;
                    deserializedKubeletConfig.allowedUnsafeSysctls = allowedUnsafeSysctls = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("failSwapOn".equals(fieldName)) {
                    deserializedKubeletConfig.failSwapOn = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("containerLogMaxSizeMB".equals(fieldName)) {
                    deserializedKubeletConfig.containerLogMaxSizeMB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("containerLogMaxFiles".equals(fieldName)) {
                    deserializedKubeletConfig.containerLogMaxFiles = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("podMaxPids".equals(fieldName)) {
                    deserializedKubeletConfig.podMaxPids = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubeletConfig;
        });
    }
}

