/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.IstioEgressGateway;
import com.azure.resourcemanager.containerservice.models.IstioIngressGateway;
import java.io.IOException;
import java.util.List;

public final class IstioComponents
implements JsonSerializable<IstioComponents> {
    private List<IstioIngressGateway> ingressGateways;
    private List<IstioEgressGateway> egressGateways;

    public List<IstioIngressGateway> ingressGateways() {
        return this.ingressGateways;
    }

    public IstioComponents withIngressGateways(List<IstioIngressGateway> ingressGateways) {
        this.ingressGateways = ingressGateways;
        return this;
    }

    public List<IstioEgressGateway> egressGateways() {
        return this.egressGateways;
    }

    public IstioComponents withEgressGateways(List<IstioEgressGateway> egressGateways) {
        this.egressGateways = egressGateways;
        return this;
    }

    public void validate() {
        if (this.ingressGateways() != null) {
            this.ingressGateways().forEach(e -> e.validate());
        }
        if (this.egressGateways() != null) {
            this.egressGateways().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ingressGateways", this.ingressGateways, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("egressGateways", this.egressGateways, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static IstioComponents fromJson(JsonReader jsonReader) throws IOException {
        return (IstioComponents)jsonReader.readObject(reader -> {
            IstioComponents deserializedIstioComponents = new IstioComponents();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ingressGateways".equals(fieldName)) {
                    List ingressGateways;
                    deserializedIstioComponents.ingressGateways = ingressGateways = reader.readArray(reader1 -> IstioIngressGateway.fromJson(reader1));
                    continue;
                }
                if ("egressGateways".equals(fieldName)) {
                    List egressGateways;
                    deserializedIstioComponents.egressGateways = egressGateways = reader.readArray(reader1 -> IstioEgressGateway.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIstioComponents;
        });
    }
}

