/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.fluent.models.OrchestratorVersionProfileProperties;
import com.azure.resourcemanager.containerservice.models.OrchestratorVersionProfile;
import java.io.IOException;
import java.util.List;

public final class OrchestratorVersionProfileListResultInner
implements JsonSerializable<OrchestratorVersionProfileListResultInner> {
    private String id;
    private String name;
    private String type;
    private OrchestratorVersionProfileProperties innerProperties = new OrchestratorVersionProfileProperties();
    private static final ClientLogger LOGGER = new ClientLogger(OrchestratorVersionProfileListResultInner.class);

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    private OrchestratorVersionProfileProperties innerProperties() {
        return this.innerProperties;
    }

    public List<OrchestratorVersionProfile> orchestrators() {
        return this.innerProperties() == null ? null : this.innerProperties().orchestrators();
    }

    public OrchestratorVersionProfileListResultInner withOrchestrators(List<OrchestratorVersionProfile> orchestrators) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OrchestratorVersionProfileProperties();
        }
        this.innerProperties().withOrchestrators(orchestrators);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model OrchestratorVersionProfileListResultInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static OrchestratorVersionProfileListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return (OrchestratorVersionProfileListResultInner)jsonReader.readObject(reader -> {
            OrchestratorVersionProfileListResultInner deserializedOrchestratorVersionProfileListResultInner = new OrchestratorVersionProfileListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedOrchestratorVersionProfileListResultInner.innerProperties = OrchestratorVersionProfileProperties.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedOrchestratorVersionProfileListResultInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedOrchestratorVersionProfileListResultInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedOrchestratorVersionProfileListResultInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOrchestratorVersionProfileListResultInner;
        });
    }
}

