/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.UndrainableNodeBehavior;
import java.io.IOException;

public final class AgentPoolUpgradeSettings
implements JsonSerializable<AgentPoolUpgradeSettings> {
    private String maxSurge;
    private String maxUnavailable;
    private Integer drainTimeoutInMinutes;
    private Integer nodeSoakDurationInMinutes;
    private UndrainableNodeBehavior undrainableNodeBehavior;

    public String maxSurge() {
        return this.maxSurge;
    }

    public AgentPoolUpgradeSettings withMaxSurge(String maxSurge) {
        this.maxSurge = maxSurge;
        return this;
    }

    public String maxUnavailable() {
        return this.maxUnavailable;
    }

    public AgentPoolUpgradeSettings withMaxUnavailable(String maxUnavailable) {
        this.maxUnavailable = maxUnavailable;
        return this;
    }

    public Integer drainTimeoutInMinutes() {
        return this.drainTimeoutInMinutes;
    }

    public AgentPoolUpgradeSettings withDrainTimeoutInMinutes(Integer drainTimeoutInMinutes) {
        this.drainTimeoutInMinutes = drainTimeoutInMinutes;
        return this;
    }

    public Integer nodeSoakDurationInMinutes() {
        return this.nodeSoakDurationInMinutes;
    }

    public AgentPoolUpgradeSettings withNodeSoakDurationInMinutes(Integer nodeSoakDurationInMinutes) {
        this.nodeSoakDurationInMinutes = nodeSoakDurationInMinutes;
        return this;
    }

    public UndrainableNodeBehavior undrainableNodeBehavior() {
        return this.undrainableNodeBehavior;
    }

    public AgentPoolUpgradeSettings withUndrainableNodeBehavior(UndrainableNodeBehavior undrainableNodeBehavior) {
        this.undrainableNodeBehavior = undrainableNodeBehavior;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("maxSurge", this.maxSurge);
        jsonWriter.writeStringField("maxUnavailable", this.maxUnavailable);
        jsonWriter.writeNumberField("drainTimeoutInMinutes", (Number)this.drainTimeoutInMinutes);
        jsonWriter.writeNumberField("nodeSoakDurationInMinutes", (Number)this.nodeSoakDurationInMinutes);
        jsonWriter.writeStringField("undrainableNodeBehavior", this.undrainableNodeBehavior == null ? null : this.undrainableNodeBehavior.toString());
        return jsonWriter.writeEndObject();
    }

    public static AgentPoolUpgradeSettings fromJson(JsonReader jsonReader) throws IOException {
        return (AgentPoolUpgradeSettings)jsonReader.readObject(reader -> {
            AgentPoolUpgradeSettings deserializedAgentPoolUpgradeSettings = new AgentPoolUpgradeSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxSurge".equals(fieldName)) {
                    deserializedAgentPoolUpgradeSettings.maxSurge = reader.getString();
                    continue;
                }
                if ("maxUnavailable".equals(fieldName)) {
                    deserializedAgentPoolUpgradeSettings.maxUnavailable = reader.getString();
                    continue;
                }
                if ("drainTimeoutInMinutes".equals(fieldName)) {
                    deserializedAgentPoolUpgradeSettings.drainTimeoutInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("nodeSoakDurationInMinutes".equals(fieldName)) {
                    deserializedAgentPoolUpgradeSettings.nodeSoakDurationInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("undrainableNodeBehavior".equals(fieldName)) {
                    deserializedAgentPoolUpgradeSettings.undrainableNodeBehavior = UndrainableNodeBehavior.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAgentPoolUpgradeSettings;
        });
    }
}

