/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.DateSpan;
import com.azure.resourcemanager.containerservice.models.Schedule;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;

public final class MaintenanceWindow
implements JsonSerializable<MaintenanceWindow> {
    private Schedule schedule;
    private int durationHours;
    private String utcOffset;
    private LocalDate startDate;
    private String startTime;
    private List<DateSpan> notAllowedDates;
    private static final ClientLogger LOGGER = new ClientLogger(MaintenanceWindow.class);

    public Schedule schedule() {
        return this.schedule;
    }

    public MaintenanceWindow withSchedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public int durationHours() {
        return this.durationHours;
    }

    public MaintenanceWindow withDurationHours(int durationHours) {
        this.durationHours = durationHours;
        return this;
    }

    public String utcOffset() {
        return this.utcOffset;
    }

    public MaintenanceWindow withUtcOffset(String utcOffset) {
        this.utcOffset = utcOffset;
        return this;
    }

    public LocalDate startDate() {
        return this.startDate;
    }

    public MaintenanceWindow withStartDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    public String startTime() {
        return this.startTime;
    }

    public MaintenanceWindow withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public List<DateSpan> notAllowedDates() {
        return this.notAllowedDates;
    }

    public MaintenanceWindow withNotAllowedDates(List<DateSpan> notAllowedDates) {
        this.notAllowedDates = notAllowedDates;
        return this;
    }

    public void validate() {
        if (this.schedule() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property schedule in model MaintenanceWindow"));
        }
        this.schedule().validate();
        if (this.startTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property startTime in model MaintenanceWindow"));
        }
        if (this.notAllowedDates() != null) {
            this.notAllowedDates().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("schedule", (JsonSerializable)this.schedule);
        jsonWriter.writeIntField("durationHours", this.durationHours);
        jsonWriter.writeStringField("startTime", this.startTime);
        jsonWriter.writeStringField("utcOffset", this.utcOffset);
        jsonWriter.writeStringField("startDate", Objects.toString(this.startDate, null));
        jsonWriter.writeArrayField("notAllowedDates", this.notAllowedDates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MaintenanceWindow fromJson(JsonReader jsonReader) throws IOException {
        return (MaintenanceWindow)jsonReader.readObject(reader -> {
            MaintenanceWindow deserializedMaintenanceWindow = new MaintenanceWindow();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schedule".equals(fieldName)) {
                    deserializedMaintenanceWindow.schedule = Schedule.fromJson(reader);
                    continue;
                }
                if ("durationHours".equals(fieldName)) {
                    deserializedMaintenanceWindow.durationHours = reader.getInt();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedMaintenanceWindow.startTime = reader.getString();
                    continue;
                }
                if ("utcOffset".equals(fieldName)) {
                    deserializedMaintenanceWindow.utcOffset = reader.getString();
                    continue;
                }
                if ("startDate".equals(fieldName)) {
                    deserializedMaintenanceWindow.startDate = (LocalDate)reader.getNullable(nonNullReader -> LocalDate.parse(nonNullReader.getString()));
                    continue;
                }
                if ("notAllowedDates".equals(fieldName)) {
                    List notAllowedDates;
                    deserializedMaintenanceWindow.notAllowedDates = notAllowedDates = reader.readArray(reader1 -> DateSpan.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMaintenanceWindow;
        });
    }
}

