/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AgentPoolUpgradeSettings
implements JsonSerializable<AgentPoolUpgradeSettings> {
    private String maxSurge;
    private Integer drainTimeoutInMinutes;
    private Integer nodeSoakDurationInMinutes;

    public String maxSurge() {
        return this.maxSurge;
    }

    public AgentPoolUpgradeSettings withMaxSurge(String maxSurge) {
        this.maxSurge = maxSurge;
        return this;
    }

    public Integer drainTimeoutInMinutes() {
        return this.drainTimeoutInMinutes;
    }

    public AgentPoolUpgradeSettings withDrainTimeoutInMinutes(Integer drainTimeoutInMinutes) {
        this.drainTimeoutInMinutes = drainTimeoutInMinutes;
        return this;
    }

    public Integer nodeSoakDurationInMinutes() {
        return this.nodeSoakDurationInMinutes;
    }

    public AgentPoolUpgradeSettings withNodeSoakDurationInMinutes(Integer nodeSoakDurationInMinutes) {
        this.nodeSoakDurationInMinutes = nodeSoakDurationInMinutes;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("maxSurge", this.maxSurge);
        jsonWriter.writeNumberField("drainTimeoutInMinutes", (Number)this.drainTimeoutInMinutes);
        jsonWriter.writeNumberField("nodeSoakDurationInMinutes", (Number)this.nodeSoakDurationInMinutes);
        return jsonWriter.writeEndObject();
    }

    public static AgentPoolUpgradeSettings fromJson(JsonReader jsonReader) throws IOException {
        return (AgentPoolUpgradeSettings)jsonReader.readObject(reader -> {
            AgentPoolUpgradeSettings deserializedAgentPoolUpgradeSettings = new AgentPoolUpgradeSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxSurge".equals(fieldName)) {
                    deserializedAgentPoolUpgradeSettings.maxSurge = reader.getString();
                    continue;
                }
                if ("drainTimeoutInMinutes".equals(fieldName)) {
                    deserializedAgentPoolUpgradeSettings.drainTimeoutInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("nodeSoakDurationInMinutes".equals(fieldName)) {
                    deserializedAgentPoolUpgradeSettings.nodeSoakDurationInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAgentPoolUpgradeSettings;
        });
    }
}

