/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.AgentPoolMode;
import com.azure.resourcemanager.containerservice.models.AgentPoolNetworkProfile;
import com.azure.resourcemanager.containerservice.models.AgentPoolSecurityProfile;
import com.azure.resourcemanager.containerservice.models.AgentPoolType;
import com.azure.resourcemanager.containerservice.models.AgentPoolUpgradeSettings;
import com.azure.resourcemanager.containerservice.models.AgentPoolWindowsProfile;
import com.azure.resourcemanager.containerservice.models.CreationData;
import com.azure.resourcemanager.containerservice.models.GpuInstanceProfile;
import com.azure.resourcemanager.containerservice.models.KubeletConfig;
import com.azure.resourcemanager.containerservice.models.KubeletDiskType;
import com.azure.resourcemanager.containerservice.models.LinuxOSConfig;
import com.azure.resourcemanager.containerservice.models.OSDiskType;
import com.azure.resourcemanager.containerservice.models.OSSku;
import com.azure.resourcemanager.containerservice.models.OSType;
import com.azure.resourcemanager.containerservice.models.PowerState;
import com.azure.resourcemanager.containerservice.models.ScaleDownMode;
import com.azure.resourcemanager.containerservice.models.ScaleSetEvictionPolicy;
import com.azure.resourcemanager.containerservice.models.ScaleSetPriority;
import com.azure.resourcemanager.containerservice.models.WorkloadRuntime;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ManagedClusterAgentPoolProfileProperties
implements JsonSerializable<ManagedClusterAgentPoolProfileProperties> {
    private String etag;
    private Integer count;
    private String vmSize;
    private Integer osDiskSizeGB;
    private OSDiskType osDiskType;
    private KubeletDiskType kubeletDiskType;
    private WorkloadRuntime workloadRuntime;
    private String messageOfTheDay;
    private String vnetSubnetId;
    private String podSubnetId;
    private Integer maxPods;
    private OSType osType;
    private OSSku osSku;
    private Integer maxCount;
    private Integer minCount;
    private Boolean enableAutoScaling;
    private ScaleDownMode scaleDownMode;
    private AgentPoolType type;
    private AgentPoolMode mode;
    private String orchestratorVersion;
    private String currentOrchestratorVersion;
    private String nodeImageVersion;
    private AgentPoolUpgradeSettings upgradeSettings;
    private String provisioningState;
    private PowerState powerState;
    private List<String> availabilityZones;
    private Boolean enableNodePublicIp;
    private String nodePublicIpPrefixId;
    private ScaleSetPriority scaleSetPriority;
    private ScaleSetEvictionPolicy scaleSetEvictionPolicy;
    private Float spotMaxPrice;
    private Map<String, String> tags;
    private Map<String, String> nodeLabels;
    private List<String> nodeTaints;
    private String proximityPlacementGroupId;
    private KubeletConfig kubeletConfig;
    private LinuxOSConfig linuxOSConfig;
    private Boolean enableEncryptionAtHost;
    private Boolean enableUltraSsd;
    private Boolean enableFips;
    private GpuInstanceProfile gpuInstanceProfile;
    private CreationData creationData;
    private String capacityReservationGroupId;
    private String hostGroupId;
    private AgentPoolNetworkProfile networkProfile;
    private AgentPoolWindowsProfile windowsProfile;
    private AgentPoolSecurityProfile securityProfile;

    public String etag() {
        return this.etag;
    }

    ManagedClusterAgentPoolProfileProperties withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public Integer count() {
        return this.count;
    }

    public ManagedClusterAgentPoolProfileProperties withCount(Integer count) {
        this.count = count;
        return this;
    }

    public String vmSize() {
        return this.vmSize;
    }

    public ManagedClusterAgentPoolProfileProperties withVmSize(String vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    public Integer osDiskSizeGB() {
        return this.osDiskSizeGB;
    }

    public ManagedClusterAgentPoolProfileProperties withOsDiskSizeGB(Integer osDiskSizeGB) {
        this.osDiskSizeGB = osDiskSizeGB;
        return this;
    }

    public OSDiskType osDiskType() {
        return this.osDiskType;
    }

    public ManagedClusterAgentPoolProfileProperties withOsDiskType(OSDiskType osDiskType) {
        this.osDiskType = osDiskType;
        return this;
    }

    public KubeletDiskType kubeletDiskType() {
        return this.kubeletDiskType;
    }

    public ManagedClusterAgentPoolProfileProperties withKubeletDiskType(KubeletDiskType kubeletDiskType) {
        this.kubeletDiskType = kubeletDiskType;
        return this;
    }

    public WorkloadRuntime workloadRuntime() {
        return this.workloadRuntime;
    }

    public ManagedClusterAgentPoolProfileProperties withWorkloadRuntime(WorkloadRuntime workloadRuntime) {
        this.workloadRuntime = workloadRuntime;
        return this;
    }

    public String messageOfTheDay() {
        return this.messageOfTheDay;
    }

    public ManagedClusterAgentPoolProfileProperties withMessageOfTheDay(String messageOfTheDay) {
        this.messageOfTheDay = messageOfTheDay;
        return this;
    }

    public String vnetSubnetId() {
        return this.vnetSubnetId;
    }

    public ManagedClusterAgentPoolProfileProperties withVnetSubnetId(String vnetSubnetId) {
        this.vnetSubnetId = vnetSubnetId;
        return this;
    }

    public String podSubnetId() {
        return this.podSubnetId;
    }

    public ManagedClusterAgentPoolProfileProperties withPodSubnetId(String podSubnetId) {
        this.podSubnetId = podSubnetId;
        return this;
    }

    public Integer maxPods() {
        return this.maxPods;
    }

    public ManagedClusterAgentPoolProfileProperties withMaxPods(Integer maxPods) {
        this.maxPods = maxPods;
        return this;
    }

    public OSType osType() {
        return this.osType;
    }

    public ManagedClusterAgentPoolProfileProperties withOsType(OSType osType) {
        this.osType = osType;
        return this;
    }

    public OSSku osSku() {
        return this.osSku;
    }

    public ManagedClusterAgentPoolProfileProperties withOsSku(OSSku osSku) {
        this.osSku = osSku;
        return this;
    }

    public Integer maxCount() {
        return this.maxCount;
    }

    public ManagedClusterAgentPoolProfileProperties withMaxCount(Integer maxCount) {
        this.maxCount = maxCount;
        return this;
    }

    public Integer minCount() {
        return this.minCount;
    }

    public ManagedClusterAgentPoolProfileProperties withMinCount(Integer minCount) {
        this.minCount = minCount;
        return this;
    }

    public Boolean enableAutoScaling() {
        return this.enableAutoScaling;
    }

    public ManagedClusterAgentPoolProfileProperties withEnableAutoScaling(Boolean enableAutoScaling) {
        this.enableAutoScaling = enableAutoScaling;
        return this;
    }

    public ScaleDownMode scaleDownMode() {
        return this.scaleDownMode;
    }

    public ManagedClusterAgentPoolProfileProperties withScaleDownMode(ScaleDownMode scaleDownMode) {
        this.scaleDownMode = scaleDownMode;
        return this;
    }

    public AgentPoolType type() {
        return this.type;
    }

    public ManagedClusterAgentPoolProfileProperties withType(AgentPoolType type) {
        this.type = type;
        return this;
    }

    public AgentPoolMode mode() {
        return this.mode;
    }

    public ManagedClusterAgentPoolProfileProperties withMode(AgentPoolMode mode) {
        this.mode = mode;
        return this;
    }

    public String orchestratorVersion() {
        return this.orchestratorVersion;
    }

    public ManagedClusterAgentPoolProfileProperties withOrchestratorVersion(String orchestratorVersion) {
        this.orchestratorVersion = orchestratorVersion;
        return this;
    }

    public String currentOrchestratorVersion() {
        return this.currentOrchestratorVersion;
    }

    ManagedClusterAgentPoolProfileProperties withCurrentOrchestratorVersion(String currentOrchestratorVersion) {
        this.currentOrchestratorVersion = currentOrchestratorVersion;
        return this;
    }

    public String nodeImageVersion() {
        return this.nodeImageVersion;
    }

    ManagedClusterAgentPoolProfileProperties withNodeImageVersion(String nodeImageVersion) {
        this.nodeImageVersion = nodeImageVersion;
        return this;
    }

    public AgentPoolUpgradeSettings upgradeSettings() {
        return this.upgradeSettings;
    }

    public ManagedClusterAgentPoolProfileProperties withUpgradeSettings(AgentPoolUpgradeSettings upgradeSettings) {
        this.upgradeSettings = upgradeSettings;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    ManagedClusterAgentPoolProfileProperties withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public PowerState powerState() {
        return this.powerState;
    }

    public ManagedClusterAgentPoolProfileProperties withPowerState(PowerState powerState) {
        this.powerState = powerState;
        return this;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public ManagedClusterAgentPoolProfileProperties withAvailabilityZones(List<String> availabilityZones) {
        this.availabilityZones = availabilityZones;
        return this;
    }

    public Boolean enableNodePublicIp() {
        return this.enableNodePublicIp;
    }

    public ManagedClusterAgentPoolProfileProperties withEnableNodePublicIp(Boolean enableNodePublicIp) {
        this.enableNodePublicIp = enableNodePublicIp;
        return this;
    }

    public String nodePublicIpPrefixId() {
        return this.nodePublicIpPrefixId;
    }

    public ManagedClusterAgentPoolProfileProperties withNodePublicIpPrefixId(String nodePublicIpPrefixId) {
        this.nodePublicIpPrefixId = nodePublicIpPrefixId;
        return this;
    }

    public ScaleSetPriority scaleSetPriority() {
        return this.scaleSetPriority;
    }

    public ManagedClusterAgentPoolProfileProperties withScaleSetPriority(ScaleSetPriority scaleSetPriority) {
        this.scaleSetPriority = scaleSetPriority;
        return this;
    }

    public ScaleSetEvictionPolicy scaleSetEvictionPolicy() {
        return this.scaleSetEvictionPolicy;
    }

    public ManagedClusterAgentPoolProfileProperties withScaleSetEvictionPolicy(ScaleSetEvictionPolicy scaleSetEvictionPolicy) {
        this.scaleSetEvictionPolicy = scaleSetEvictionPolicy;
        return this;
    }

    public Float spotMaxPrice() {
        return this.spotMaxPrice;
    }

    public ManagedClusterAgentPoolProfileProperties withSpotMaxPrice(Float spotMaxPrice) {
        this.spotMaxPrice = spotMaxPrice;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ManagedClusterAgentPoolProfileProperties withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Map<String, String> nodeLabels() {
        return this.nodeLabels;
    }

    public ManagedClusterAgentPoolProfileProperties withNodeLabels(Map<String, String> nodeLabels) {
        this.nodeLabels = nodeLabels;
        return this;
    }

    public List<String> nodeTaints() {
        return this.nodeTaints;
    }

    public ManagedClusterAgentPoolProfileProperties withNodeTaints(List<String> nodeTaints) {
        this.nodeTaints = nodeTaints;
        return this;
    }

    public String proximityPlacementGroupId() {
        return this.proximityPlacementGroupId;
    }

    public ManagedClusterAgentPoolProfileProperties withProximityPlacementGroupId(String proximityPlacementGroupId) {
        this.proximityPlacementGroupId = proximityPlacementGroupId;
        return this;
    }

    public KubeletConfig kubeletConfig() {
        return this.kubeletConfig;
    }

    public ManagedClusterAgentPoolProfileProperties withKubeletConfig(KubeletConfig kubeletConfig) {
        this.kubeletConfig = kubeletConfig;
        return this;
    }

    public LinuxOSConfig linuxOSConfig() {
        return this.linuxOSConfig;
    }

    public ManagedClusterAgentPoolProfileProperties withLinuxOSConfig(LinuxOSConfig linuxOSConfig) {
        this.linuxOSConfig = linuxOSConfig;
        return this;
    }

    public Boolean enableEncryptionAtHost() {
        return this.enableEncryptionAtHost;
    }

    public ManagedClusterAgentPoolProfileProperties withEnableEncryptionAtHost(Boolean enableEncryptionAtHost) {
        this.enableEncryptionAtHost = enableEncryptionAtHost;
        return this;
    }

    public Boolean enableUltraSsd() {
        return this.enableUltraSsd;
    }

    public ManagedClusterAgentPoolProfileProperties withEnableUltraSsd(Boolean enableUltraSsd) {
        this.enableUltraSsd = enableUltraSsd;
        return this;
    }

    public Boolean enableFips() {
        return this.enableFips;
    }

    public ManagedClusterAgentPoolProfileProperties withEnableFips(Boolean enableFips) {
        this.enableFips = enableFips;
        return this;
    }

    public GpuInstanceProfile gpuInstanceProfile() {
        return this.gpuInstanceProfile;
    }

    public ManagedClusterAgentPoolProfileProperties withGpuInstanceProfile(GpuInstanceProfile gpuInstanceProfile) {
        this.gpuInstanceProfile = gpuInstanceProfile;
        return this;
    }

    public CreationData creationData() {
        return this.creationData;
    }

    public ManagedClusterAgentPoolProfileProperties withCreationData(CreationData creationData) {
        this.creationData = creationData;
        return this;
    }

    public String capacityReservationGroupId() {
        return this.capacityReservationGroupId;
    }

    public ManagedClusterAgentPoolProfileProperties withCapacityReservationGroupId(String capacityReservationGroupId) {
        this.capacityReservationGroupId = capacityReservationGroupId;
        return this;
    }

    public String hostGroupId() {
        return this.hostGroupId;
    }

    public ManagedClusterAgentPoolProfileProperties withHostGroupId(String hostGroupId) {
        this.hostGroupId = hostGroupId;
        return this;
    }

    public AgentPoolNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public ManagedClusterAgentPoolProfileProperties withNetworkProfile(AgentPoolNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public AgentPoolWindowsProfile windowsProfile() {
        return this.windowsProfile;
    }

    public ManagedClusterAgentPoolProfileProperties withWindowsProfile(AgentPoolWindowsProfile windowsProfile) {
        this.windowsProfile = windowsProfile;
        return this;
    }

    public AgentPoolSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public ManagedClusterAgentPoolProfileProperties withSecurityProfile(AgentPoolSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public void validate() {
        if (this.upgradeSettings() != null) {
            this.upgradeSettings().validate();
        }
        if (this.powerState() != null) {
            this.powerState().validate();
        }
        if (this.kubeletConfig() != null) {
            this.kubeletConfig().validate();
        }
        if (this.linuxOSConfig() != null) {
            this.linuxOSConfig().validate();
        }
        if (this.creationData() != null) {
            this.creationData().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.windowsProfile() != null) {
            this.windowsProfile().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("count", (Number)this.count);
        jsonWriter.writeStringField("vmSize", this.vmSize);
        jsonWriter.writeNumberField("osDiskSizeGB", (Number)this.osDiskSizeGB);
        jsonWriter.writeStringField("osDiskType", this.osDiskType == null ? null : this.osDiskType.toString());
        jsonWriter.writeStringField("kubeletDiskType", this.kubeletDiskType == null ? null : this.kubeletDiskType.toString());
        jsonWriter.writeStringField("workloadRuntime", this.workloadRuntime == null ? null : this.workloadRuntime.toString());
        jsonWriter.writeStringField("messageOfTheDay", this.messageOfTheDay);
        jsonWriter.writeStringField("vnetSubnetID", this.vnetSubnetId);
        jsonWriter.writeStringField("podSubnetID", this.podSubnetId);
        jsonWriter.writeNumberField("maxPods", (Number)this.maxPods);
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("osSKU", this.osSku == null ? null : this.osSku.toString());
        jsonWriter.writeNumberField("maxCount", (Number)this.maxCount);
        jsonWriter.writeNumberField("minCount", (Number)this.minCount);
        jsonWriter.writeBooleanField("enableAutoScaling", this.enableAutoScaling);
        jsonWriter.writeStringField("scaleDownMode", this.scaleDownMode == null ? null : this.scaleDownMode.toString());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeStringField("orchestratorVersion", this.orchestratorVersion);
        jsonWriter.writeJsonField("upgradeSettings", (JsonSerializable)this.upgradeSettings);
        jsonWriter.writeJsonField("powerState", (JsonSerializable)this.powerState);
        jsonWriter.writeArrayField("availabilityZones", this.availabilityZones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("enableNodePublicIP", this.enableNodePublicIp);
        jsonWriter.writeStringField("nodePublicIPPrefixID", this.nodePublicIpPrefixId);
        jsonWriter.writeStringField("scaleSetPriority", this.scaleSetPriority == null ? null : this.scaleSetPriority.toString());
        jsonWriter.writeStringField("scaleSetEvictionPolicy", this.scaleSetEvictionPolicy == null ? null : this.scaleSetEvictionPolicy.toString());
        jsonWriter.writeNumberField("spotMaxPrice", (Number)this.spotMaxPrice);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("nodeLabels", this.nodeLabels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("nodeTaints", this.nodeTaints, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("proximityPlacementGroupID", this.proximityPlacementGroupId);
        jsonWriter.writeJsonField("kubeletConfig", (JsonSerializable)this.kubeletConfig);
        jsonWriter.writeJsonField("linuxOSConfig", (JsonSerializable)this.linuxOSConfig);
        jsonWriter.writeBooleanField("enableEncryptionAtHost", this.enableEncryptionAtHost);
        jsonWriter.writeBooleanField("enableUltraSSD", this.enableUltraSsd);
        jsonWriter.writeBooleanField("enableFIPS", this.enableFips);
        jsonWriter.writeStringField("gpuInstanceProfile", this.gpuInstanceProfile == null ? null : this.gpuInstanceProfile.toString());
        jsonWriter.writeJsonField("creationData", (JsonSerializable)this.creationData);
        jsonWriter.writeStringField("capacityReservationGroupID", this.capacityReservationGroupId);
        jsonWriter.writeStringField("hostGroupID", this.hostGroupId);
        jsonWriter.writeJsonField("networkProfile", (JsonSerializable)this.networkProfile);
        jsonWriter.writeJsonField("windowsProfile", (JsonSerializable)this.windowsProfile);
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile);
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterAgentPoolProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedClusterAgentPoolProfileProperties)jsonReader.readObject(reader -> {
            ManagedClusterAgentPoolProfileProperties deserializedManagedClusterAgentPoolProfileProperties = new ManagedClusterAgentPoolProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("eTag".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.etag = reader.getString();
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.count = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("vmSize".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.vmSize = reader.getString();
                    continue;
                }
                if ("osDiskSizeGB".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.osDiskSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("osDiskType".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.osDiskType = OSDiskType.fromString(reader.getString());
                    continue;
                }
                if ("kubeletDiskType".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.kubeletDiskType = KubeletDiskType.fromString(reader.getString());
                    continue;
                }
                if ("workloadRuntime".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.workloadRuntime = WorkloadRuntime.fromString(reader.getString());
                    continue;
                }
                if ("messageOfTheDay".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.messageOfTheDay = reader.getString();
                    continue;
                }
                if ("vnetSubnetID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.vnetSubnetId = reader.getString();
                    continue;
                }
                if ("podSubnetID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.podSubnetId = reader.getString();
                    continue;
                }
                if ("maxPods".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.maxPods = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.osType = OSType.fromString(reader.getString());
                    continue;
                }
                if ("osSKU".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.osSku = OSSku.fromString(reader.getString());
                    continue;
                }
                if ("maxCount".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.maxCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("minCount".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.minCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("enableAutoScaling".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.enableAutoScaling = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("scaleDownMode".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.scaleDownMode = ScaleDownMode.fromString(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.type = AgentPoolType.fromString(reader.getString());
                    continue;
                }
                if ("mode".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.mode = AgentPoolMode.fromString(reader.getString());
                    continue;
                }
                if ("orchestratorVersion".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.orchestratorVersion = reader.getString();
                    continue;
                }
                if ("currentOrchestratorVersion".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.currentOrchestratorVersion = reader.getString();
                    continue;
                }
                if ("nodeImageVersion".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.nodeImageVersion = reader.getString();
                    continue;
                }
                if ("upgradeSettings".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.upgradeSettings = AgentPoolUpgradeSettings.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("powerState".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.powerState = PowerState.fromJson(reader);
                    continue;
                }
                if ("availabilityZones".equals(fieldName)) {
                    List availabilityZones;
                    deserializedManagedClusterAgentPoolProfileProperties.availabilityZones = availabilityZones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("enableNodePublicIP".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.enableNodePublicIp = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("nodePublicIPPrefixID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.nodePublicIpPrefixId = reader.getString();
                    continue;
                }
                if ("scaleSetPriority".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.scaleSetPriority = ScaleSetPriority.fromString(reader.getString());
                    continue;
                }
                if ("scaleSetEvictionPolicy".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.scaleSetEvictionPolicy = ScaleSetEvictionPolicy.fromString(reader.getString());
                    continue;
                }
                if ("spotMaxPrice".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.spotMaxPrice = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedManagedClusterAgentPoolProfileProperties.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("nodeLabels".equals(fieldName)) {
                    Map nodeLabels;
                    deserializedManagedClusterAgentPoolProfileProperties.nodeLabels = nodeLabels = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("nodeTaints".equals(fieldName)) {
                    List nodeTaints;
                    deserializedManagedClusterAgentPoolProfileProperties.nodeTaints = nodeTaints = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("proximityPlacementGroupID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.proximityPlacementGroupId = reader.getString();
                    continue;
                }
                if ("kubeletConfig".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.kubeletConfig = KubeletConfig.fromJson(reader);
                    continue;
                }
                if ("linuxOSConfig".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.linuxOSConfig = LinuxOSConfig.fromJson(reader);
                    continue;
                }
                if ("enableEncryptionAtHost".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.enableEncryptionAtHost = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableUltraSSD".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.enableUltraSsd = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableFIPS".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.enableFips = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("gpuInstanceProfile".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.gpuInstanceProfile = GpuInstanceProfile.fromString(reader.getString());
                    continue;
                }
                if ("creationData".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.creationData = CreationData.fromJson(reader);
                    continue;
                }
                if ("capacityReservationGroupID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.capacityReservationGroupId = reader.getString();
                    continue;
                }
                if ("hostGroupID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.hostGroupId = reader.getString();
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.networkProfile = AgentPoolNetworkProfile.fromJson(reader);
                    continue;
                }
                if ("windowsProfile".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.windowsProfile = AgentPoolWindowsProfile.fromJson(reader);
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.securityProfile = AgentPoolSecurityProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterAgentPoolProfileProperties;
        });
    }
}

