/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.models.ContainerServiceStorageProfileTypes;
import com.azure.resourcemanager.containerservice.models.ContainerServiceVMSizeTypes;
import com.azure.resourcemanager.containerservice.models.Count;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ContainerServiceMasterProfile {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ContainerServiceMasterProfile.class);
    @JsonProperty(value="count")
    private Count count;
    @JsonProperty(value="dnsPrefix", required=true)
    private String dnsPrefix;
    @JsonProperty(value="vmSize", required=true)
    private ContainerServiceVMSizeTypes vmSize;
    @JsonProperty(value="osDiskSizeGB")
    private Integer osDiskSizeGB;
    @JsonProperty(value="vnetSubnetID")
    private String vnetSubnetId;
    @JsonProperty(value="firstConsecutiveStaticIP")
    private String firstConsecutiveStaticIp;
    @JsonProperty(value="storageProfile")
    private ContainerServiceStorageProfileTypes storageProfile;
    @JsonProperty(value="fqdn", access=JsonProperty.Access.WRITE_ONLY)
    private String fqdn;

    public Count count() {
        return this.count;
    }

    public ContainerServiceMasterProfile withCount(Count count) {
        this.count = count;
        return this;
    }

    public String dnsPrefix() {
        return this.dnsPrefix;
    }

    public ContainerServiceMasterProfile withDnsPrefix(String dnsPrefix) {
        this.dnsPrefix = dnsPrefix;
        return this;
    }

    public ContainerServiceVMSizeTypes vmSize() {
        return this.vmSize;
    }

    public ContainerServiceMasterProfile withVmSize(ContainerServiceVMSizeTypes vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    public Integer osDiskSizeGB() {
        return this.osDiskSizeGB;
    }

    public ContainerServiceMasterProfile withOsDiskSizeGB(Integer osDiskSizeGB) {
        this.osDiskSizeGB = osDiskSizeGB;
        return this;
    }

    public String vnetSubnetId() {
        return this.vnetSubnetId;
    }

    public ContainerServiceMasterProfile withVnetSubnetId(String vnetSubnetId) {
        this.vnetSubnetId = vnetSubnetId;
        return this;
    }

    public String firstConsecutiveStaticIp() {
        return this.firstConsecutiveStaticIp;
    }

    public ContainerServiceMasterProfile withFirstConsecutiveStaticIp(String firstConsecutiveStaticIp) {
        this.firstConsecutiveStaticIp = firstConsecutiveStaticIp;
        return this;
    }

    public ContainerServiceStorageProfileTypes storageProfile() {
        return this.storageProfile;
    }

    public ContainerServiceMasterProfile withStorageProfile(ContainerServiceStorageProfileTypes storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public void validate() {
        if (this.dnsPrefix() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property dnsPrefix in model ContainerServiceMasterProfile"));
        }
        if (this.vmSize() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property vmSize in model ContainerServiceMasterProfile"));
        }
    }
}

