/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.models.ContainerServiceStorageProfileTypes;
import com.azure.resourcemanager.containerservice.models.ContainerServiceVMSizeTypes;
import com.azure.resourcemanager.containerservice.models.OSType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ContainerServiceAgentPoolProfile {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ContainerServiceAgentPoolProfile.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="count")
    private Integer count;
    @JsonProperty(value="vmSize", required=true)
    private ContainerServiceVMSizeTypes vmSize;
    @JsonProperty(value="osDiskSizeGB")
    private Integer osDiskSizeGB;
    @JsonProperty(value="dnsPrefix")
    private String dnsPrefix;
    @JsonProperty(value="fqdn", access=JsonProperty.Access.WRITE_ONLY)
    private String fqdn;
    @JsonProperty(value="ports")
    private List<Integer> ports;
    @JsonProperty(value="storageProfile")
    private ContainerServiceStorageProfileTypes storageProfile;
    @JsonProperty(value="vnetSubnetID")
    private String vnetSubnetId;
    @JsonProperty(value="osType")
    private OSType osType;

    public String name() {
        return this.name;
    }

    public ContainerServiceAgentPoolProfile withName(String name) {
        this.name = name;
        return this;
    }

    public Integer count() {
        return this.count;
    }

    public ContainerServiceAgentPoolProfile withCount(Integer count) {
        this.count = count;
        return this;
    }

    public ContainerServiceVMSizeTypes vmSize() {
        return this.vmSize;
    }

    public ContainerServiceAgentPoolProfile withVmSize(ContainerServiceVMSizeTypes vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    public Integer osDiskSizeGB() {
        return this.osDiskSizeGB;
    }

    public ContainerServiceAgentPoolProfile withOsDiskSizeGB(Integer osDiskSizeGB) {
        this.osDiskSizeGB = osDiskSizeGB;
        return this;
    }

    public String dnsPrefix() {
        return this.dnsPrefix;
    }

    public ContainerServiceAgentPoolProfile withDnsPrefix(String dnsPrefix) {
        this.dnsPrefix = dnsPrefix;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public List<Integer> ports() {
        return this.ports;
    }

    public ContainerServiceAgentPoolProfile withPorts(List<Integer> ports) {
        this.ports = ports;
        return this;
    }

    public ContainerServiceStorageProfileTypes storageProfile() {
        return this.storageProfile;
    }

    public ContainerServiceAgentPoolProfile withStorageProfile(ContainerServiceStorageProfileTypes storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public String vnetSubnetId() {
        return this.vnetSubnetId;
    }

    public ContainerServiceAgentPoolProfile withVnetSubnetId(String vnetSubnetId) {
        this.vnetSubnetId = vnetSubnetId;
        return this;
    }

    public OSType osType() {
        return this.osType;
    }

    public ContainerServiceAgentPoolProfile withOsType(OSType osType) {
        this.osType = osType;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model ContainerServiceAgentPoolProfile"));
        }
        if (this.vmSize() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property vmSize in model ContainerServiceAgentPoolProfile"));
        }
    }
}

