/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.models.AgentPoolUpgradeProfilePropertiesUpgradesItem;
import com.azure.resourcemanager.containerservice.models.OSType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class AgentPoolUpgradeProfileInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AgentPoolUpgradeProfileInner.class);
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    @JsonProperty(value="name", access=JsonProperty.Access.WRITE_ONLY)
    private String name;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="properties.kubernetesVersion", required=true)
    private String kubernetesVersion;
    @JsonProperty(value="properties.osType", required=true)
    private OSType osType;
    @JsonProperty(value="properties.upgrades")
    private List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades;
    @JsonProperty(value="properties.latestNodeImageVersion")
    private String latestNodeImageVersion;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public AgentPoolUpgradeProfileInner withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    public OSType osType() {
        return this.osType;
    }

    public AgentPoolUpgradeProfileInner withOsType(OSType osType) {
        this.osType = osType;
        return this;
    }

    public List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades() {
        return this.upgrades;
    }

    public AgentPoolUpgradeProfileInner withUpgrades(List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades) {
        this.upgrades = upgrades;
        return this;
    }

    public String latestNodeImageVersion() {
        return this.latestNodeImageVersion;
    }

    public AgentPoolUpgradeProfileInner withLatestNodeImageVersion(String latestNodeImageVersion) {
        this.latestNodeImageVersion = latestNodeImageVersion;
        return this;
    }

    public void validate() {
        if (this.kubernetesVersion() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property kubernetesVersion in model AgentPoolUpgradeProfileInner"));
        }
        if (this.osType() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property osType in model AgentPoolUpgradeProfileInner"));
        }
        if (this.upgrades() != null) {
            this.upgrades().forEach(e -> e.validate());
        }
    }
}

